/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PenguinPacket;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownDataClient;
import joshie.harvest.town.TownTrackerClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Packet(value=Packet.Side.CLIENT)
public class PacketSyncTowns
extends PenguinPacket {
    private Set<TownData> towns;

    public PacketSyncTowns() {
    }

    public PacketSyncTowns(Set<TownData> townData) {
        this.towns = townData;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (TownData town : this.towns) {
            NBTTagCompound compound = new NBTTagCompound();
            town.writeToNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a("Towns", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.towns = new HashSet<TownData>();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagList list = tag.func_150295_c("Towns", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            TownDataClient town = new TownDataClient();
            town.readFromNBT(compound);
            this.towns.add(town);
        }
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        ((TownTrackerClient)HFTrackers.getTownTracker(player.field_70170_p)).setTowns(this.towns);
    }
}

