/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town.packet;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.UUID;
import joshie.harvest.buildings.BuildingStage;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PenguinPacket;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownDataClient;
import joshie.harvest.town.TownTracker;
import joshie.harvest.town.TownTrackerClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Packet(value=Packet.Side.CLIENT)
public class PacketSyncBuilding
extends PenguinPacket {
    private UUID town;
    private LinkedList<BuildingStage> building;

    public PacketSyncBuilding() {
    }

    public PacketSyncBuilding(UUID town, LinkedList<BuildingStage> building) {
        this.town = town;
        this.building = building;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.town.toString());
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (BuildingStage stage : this.building) {
            NBTTagCompound compound = new NBTTagCompound();
            stage.writeToNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a("Building", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.town = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.building = new LinkedList();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagList list = tag.func_150295_c("Building", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.building.add(BuildingStage.readFromNBT(list.func_150305_b(i)));
        }
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        TownData townData = ((TownTrackerClient)HFTrackers.getTownTracker(player.field_70170_p)).getTownByID(this.town);
        if (townData != TownTracker.NULL_TOWN) {
            ((TownDataClient)townData).setBuilding(this.building);
        }
    }
}

