/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PenguinPacket;
import joshie.harvest.town.TownBuilding;
import joshie.harvest.town.TownTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Packet(value=Packet.Side.CLIENT)
public class PacketNewBuilding
extends PenguinPacket {
    private UUID uuid;
    private TownBuilding building;

    public PacketNewBuilding() {
    }

    public PacketNewBuilding(UUID uuid, TownBuilding building) {
        this.uuid = uuid;
        this.building = building;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid.toString());
        NBTTagCompound tag = new NBTTagCompound();
        this.building.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.building = new TownBuilding();
        this.building.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        ((TownTracker)HFTrackers.getTownTracker(player.field_70170_p)).getTownByID(this.uuid).addBuilding(this.building);
    }
}

