/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town.data;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.api.quests.QuestType;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.BuildingStage;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.interfaces.IQuestMaster;
import joshie.harvest.gathering.GatheringData;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.NPCRegistry;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.npc.entity.EntityNPCHuman;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.data.QuestDataServer;
import joshie.harvest.quests.packet.PacketQuest;
import joshie.harvest.town.data.TownBuilding;
import joshie.harvest.town.data.TownData;
import joshie.harvest.town.packet.PacketDailyQuest;
import joshie.harvest.town.packet.PacketNewBuilding;
import joshie.harvest.town.packet.PacketSyncBuilding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TownDataServer
extends TownData<QuestDataServer>
implements IQuestMaster {
    public final GatheringData gathering = new GatheringData();
    private Set<ResourceLocation> deadVillagers = new HashSet<ResourceLocation>();
    private final QuestDataServer quests = new QuestDataServer(this);
    private int dimension;

    public TownDataServer() {
    }

    public TownDataServer(int dimension, BlockPos townCentre) {
        this.dimension = dimension;
        this.townCentre = townCentre;
        this.uuid = UUID.randomUUID();
    }

    @Override
    public QuestDataServer getQuests() {
        return this.quests;
    }

    @Override
    public QuestType getQuestType() {
        return QuestType.TOWN;
    }

    @Override
    public void sync(@Nullable EntityPlayer player, PacketQuest packet) {
        if (player != null) {
            PacketHandler.sendToClient(packet.setUUID(this.getID()), player);
        } else {
            PacketHandler.sendToDimension(this.dimension, packet.setUUID(this.getID()));
        }
    }

    private boolean isDead(INPC npc) {
        return this.deadVillagers.contains(((NPC)npc).getRegistryName());
    }

    public void createNewBuilder(World world, BlockPos pos) {
        if (!this.isDead(HFNPCs.BUILDER)) {
            EntityNPCBuilder creator = new EntityNPCBuilder(world);
            creator.func_70634_a(pos.func_177958_n(), (double)pos.func_177956_o() + 1.5, pos.func_177952_p());
            creator.setSpawnHome(this);
            creator.func_184221_a(this.getID());
            world.func_72838_d((Entity)creator);
        }
    }

    public void markNPCDead(ResourceLocation name) {
        this.deadVillagers.add(name);
    }

    public EntityNPCBuilder getBuilder(WorldServer world) {
        return (EntityNPCBuilder)world.func_175733_a(this.getID());
    }

    public void syncBuildings(World world) {
        PacketHandler.sendToDimension(world.field_73011_w.getDimension(), new PacketSyncBuilding(this.getID(), this.building));
    }

    public boolean setBuilding(World world, BuildingImpl building, BlockPos pos, Rotation rotation) {
        BuildingStage stage = new BuildingStage(building, pos, rotation);
        if (!this.building.contains(stage)) {
            this.building.addLast(stage);
            HFTrackers.markDirty(world);
            this.syncBuildings(world);
            return true;
        }
        return false;
    }

    public void finishBuilding(World world) {
        this.building.removeFirst();
        HFTrackers.markDirty(world);
    }

    public void addBuilding(World world, BuildingImpl building, Rotation rotation, BlockPos pos) {
        TownBuilding newBuilding = new TownBuilding(building, rotation, pos);
        this.buildings.put(BuildingRegistry.REGISTRY.getKey((IForgeRegistryEntry)building), newBuilding);
        PacketHandler.sendToDimension(world.field_73011_w.getDimension(), new PacketNewBuilding(this.uuid, newBuilding));
        HFTrackers.markDirty(world);
    }

    private boolean isRepeatable(World world, Quest quest) {
        if (!quest.isRepeatable()) {
            return false;
        }
        if (quest.getDaysBetween() == 0) {
            return true;
        }
        CalendarDate date = this.getQuests().getLastCompletionOfQuest(quest);
        return date == null || CalendarHelper.getDays((CalendarDate)date, (CalendarDate)HFApi.calendar.getDate(world)) >= quest.getDaysBetween();
    }

    private void generateNewDailyQuest(World world) {
        ArrayList<Quest> quests = new ArrayList<Quest>();
        for (Quest quest : Quest.REGISTRY) {
            if (!this.isRepeatable(world, quest) && this.getQuests().getFinished().contains((Object)quest) || this.getQuests().getCurrent().contains((Object)quest) || !quest.canStartDailyQuest(world, this.townCentre)) continue;
            quests.add(quest);
        }
        if (quests.size() > 0) {
            this.dailyQuest = (Quest)((Object)quests.get(world.field_73012_v.nextInt(quests.size())));
            PacketHandler.sendToDimension(world.field_73011_w.getDimension(), (IMessage)new PacketDailyQuest(this.uuid, this.dailyQuest));
        }
    }

    public void newDay(World world, Cache<BlockPos, Boolean> isFar) {
        if (world.func_175667_e(this.getTownCentre())) {
            this.shops.newDay(world, this.uuid);
            this.gathering.newDay(world, this.townCentre, this.buildings.values(), isFar);
            this.generateNewDailyQuest(world);
            for (ResourceLocation villager : this.deadVillagers) {
                NPC npc = (NPC)NPCRegistry.REGISTRY.getValue(villager);
                if (npc == HFNPCs.GODDESS) continue;
                EntityNPCHuman entity = (EntityNPCHuman)((Object)NPCHelper.getEntityForNPC(world, npc));
                entity.func_70107_b(this.townCentre.func_177958_n(), this.townCentre.func_177956_o(), this.townCentre.func_177952_p());
                entity.resetSpawnHome();
                BlockPos pos = entity.getHomeCoordinates();
                for (int attempts = 0; !EntityHelper.isSpawnable(world, pos) && attempts < 64; ++attempts) {
                    pos = pos.func_177982_a(world.field_73012_v.nextInt(16) - 8, world.field_73012_v.nextInt(8), world.field_73012_v.nextInt(16) - 8);
                }
                entity.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (npc == HFNPCs.BUILDER) {
                    entity.func_184221_a(this.getID());
                }
                world.func_72838_d((Entity)entity);
            }
            this.deadVillagers = new HashSet<ResourceLocation>();
        }
    }

    public Rotation getFacingFor(ResourceLocation resource) {
        TownBuilding building = (TownBuilding)this.buildings.get(resource);
        if (building == null) {
            return null;
        }
        return building.getFacing();
    }

    public void writePacketNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.quests.readFromNBT(nbt);
        this.gathering.readFromNBT(nbt);
        this.dimension = nbt.func_74762_e("Dimension");
        this.deadVillagers = NBTHelper.readResourceSet(nbt, "DeadVillagers");
        if (!nbt.func_74764_b("CurrentQuests") && !nbt.func_74764_b("FinishedQuests")) {
            if (this.buildings.containsKey(((BuildingImpl)HFBuildings.CAFE).getRegistryName())) {
                this.quests.getFinished().add(Quests.BUILDING_CAFE);
            }
            if (this.buildings.containsKey(((BuildingImpl)HFBuildings.FISHING_HUT).getRegistryName())) {
                this.quests.getFinished().add(Quests.BUILDING_FISHER);
            }
            if (this.buildings.containsKey(((BuildingImpl)HFBuildings.BLACKSMITH).getRegistryName())) {
                this.quests.getFinished().add(Quests.BUILDING_BLACKSMITH);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.quests.writeToNBT(nbt);
        this.gathering.writeToNBT(nbt);
        nbt.func_74768_a("Dimension", this.dimension);
        nbt.func_74782_a("DeadVillagers", (NBTBase)NBTHelper.writeResourceSet(this.deadVillagers));
    }
}

