/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import joshie.harvest.api.buildings.Building;
import joshie.harvest.api.buildings.BuildingLocation;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingStage;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.quests.data.QuestData;
import joshie.harvest.shops.data.ShopData;
import joshie.harvest.town.data.TownBuilding;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public abstract class TownData<Q extends QuestData> {
    protected Map<ResourceLocation, TownBuilding> buildings = new HashMap<ResourceLocation, TownBuilding>();
    protected LinkedList<BuildingStage> building = new LinkedList();
    protected final Set<ResourceLocation> inhabitants = new HashSet<ResourceLocation>();
    protected final ShopData shops = new ShopData();
    protected Quest dailyQuest;
    protected BlockPos townCentre;
    protected UUID uuid;

    public abstract Q getQuests();

    public UUID getID() {
        return this.uuid;
    }

    public ShopData getShops() {
        return this.shops;
    }

    public TownData setUUID(UUID UUID2) {
        this.uuid = UUID2;
        return this;
    }

    public TownBuilding getBuilding(Building supermarket) {
        return this.buildings.get(supermarket.getResource());
    }

    public BuildingStage getCurrentlyBuilding() {
        return this.building.size() > 0 ? this.building.getFirst() : null;
    }

    public boolean isBuilding(BuildingImpl building) {
        if (building == null) {
            return this.building.size() > 0;
        }
        return this.building.contains(new BuildingStage(building, BlockPos.field_177992_a, Rotation.NONE));
    }

    public boolean hasBuilding(ResourceLocation building) {
        return this.buildings.get(building) != null;
    }

    public boolean hasBuilding(Building building) {
        return this.buildings.get(((BuildingImpl)building).getRegistryName()) != null;
    }

    public boolean hasBuildings(ResourceLocation[] buildings) {
        for (ResourceLocation building : buildings) {
            if (this.buildings.get(building) != null) continue;
            return false;
        }
        return true;
    }

    public BlockPos getCoordinatesFor(BuildingLocation location) {
        if (location == null) {
            return null;
        }
        TownBuilding building = this.buildings.get(location.getResource());
        if (building == null) {
            return null;
        }
        return building.getRealCoordinatesFor(location.getLocation());
    }

    public Set<ResourceLocation> getInhabitants() {
        return this.inhabitants;
    }

    public Collection<TownBuilding> getBuildings() {
        return this.buildings.values();
    }

    public BlockPos getTownCentre() {
        return this.townCentre;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.shops.readFromNBT(nbt);
        this.uuid = NBTHelper.readUUID("Town", nbt);
        this.townCentre = NBTHelper.readBlockPos("TownCentre", nbt);
        NBTHelper.readMap((String)"TownBuildingList", TownBuilding.class, this.buildings, (NBTTagCompound)nbt);
        NBTHelper.readList((String)"CurrentlyBuilding", BuildingStage.class, this.building, (NBTTagCompound)nbt);
        for (TownBuilding building : this.buildings.values()) {
            this.inhabitants.addAll(building.building.getInhabitants());
        }
        if (nbt.func_74764_b("DailyQuest")) {
            this.dailyQuest = (Quest)Quest.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("DailyQuest")));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.shops.writeToNBT(nbt);
        NBTHelper.writeBlockPos("TownCentre", nbt, this.townCentre);
        NBTHelper.writeUUID("Town", nbt, this.uuid);
        NBTHelper.writeMap((String)"TownBuildingList", (NBTTagCompound)nbt, this.buildings);
        NBTHelper.writeList((String)"CurrentlyBuilding", (NBTTagCompound)nbt, this.building);
        if (this.dailyQuest != null) {
            nbt.func_74778_a("DailyQuest", ((Object)((Object)this.dailyQuest)).toString());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TownData townData = (TownData)o;
        return this.uuid != null ? this.uuid.equals(townData.uuid) : townData.uuid == null;
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }
}

