/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town.data;

import java.util.Map;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.entities.PlaceableNPC;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.util.Direction;
import joshie.harvest.core.util.interfaces.INBTSerializableMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TownBuilding
implements INBTSerializableMap<ResourceLocation, TownBuilding, NBTTagCompound> {
    public BuildingImpl building;
    public Rotation rotation;
    public BlockPos pos;

    public TownBuilding() {
    }

    public TownBuilding(BuildingImpl building, Rotation rotation, BlockPos pos) {
        this.building = building;
        this.rotation = rotation;
        this.pos = pos;
    }

    public Rotation getFacing() {
        return this.rotation;
    }

    public BlockPos getRealCoordinatesFor(Placeable placeable) {
        return placeable.getTransformedPosition(this.pos, this.rotation);
    }

    public BlockPos getRealCoordinatesFor(String npc_location) {
        PlaceableNPC offsets = this.building.getNPCOffset(npc_location);
        if (offsets == null) {
            return null;
        }
        return this.getRealCoordinatesFor(offsets);
    }

    @Override
    public void buildMap(Map<ResourceLocation, TownBuilding> map) {
        map.put(BuildingRegistry.REGISTRY.getKey((IForgeRegistryEntry)this.building), this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.building = (BuildingImpl)BuildingRegistry.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("Building")));
        this.pos = NBTHelper.readBlockPos("Building", nbt);
        if (nbt.func_74764_b("Direction")) {
            Direction direction = Direction.valueOf(nbt.func_74779_i("Direction"));
            this.rotation = direction.getRotation();
        } else {
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rotation"));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Building", BuildingRegistry.REGISTRY.getKey((IForgeRegistryEntry)this.building).toString());
        nbt.func_74778_a("Rotation", this.rotation.name());
        NBTHelper.writeBlockPos("Building", nbt, this.pos);
        return nbt;
    }
}

