/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import joshie.harvest.api.buildings.BuildingLocation;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.Direction;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownDataServer;
import joshie.harvest.town.TownTracker;
import joshie.harvest.town.packet.PacketNewTown;
import joshie.harvest.town.packet.PacketSyncTowns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TownTrackerServer
extends TownTracker {
    private static final BuildingLocation MINE = new BuildingLocation(HFBuildings.MINING_HILL, "mine.front");
    private BiMap<UUID, Integer> townIDs = HashBiMap.create();

    public void newDay() {
        for (TownData town : this.townData) {
            town.newDay(this.getWorld());
        }
    }

    public void syncToPlayer(EntityPlayer player) {
        PacketHandler.sendToClient(new PacketSyncTowns(this.townData), player);
    }

    @Override
    public BlockPos getCoordinatesForOverworldMine(Entity entity, int mineID) {
        BlockPos default_ = super.getCoordinatesForOverworldMine(entity, mineID);
        UUID uuid = (UUID)this.townIDs.inverse().get((Object)mineID);
        if (uuid == null) {
            return default_;
        }
        TownData data = (TownData)this.uuidMap.get(uuid);
        if (data == null) {
            return default_;
        }
        if (!data.hasBuilding(MINE.getResource())) {
            return data.getTownCentre();
        }
        BlockPos location = data.getCoordinatesFor(MINE);
        return location != null ? location : data.getTownCentre();
    }

    @Override
    public Direction getMineOrientation(int mineID) {
        UUID uuid = (UUID)this.townIDs.inverse().get((Object)mineID);
        if (uuid == null) {
            return Direction.MN_R0;
        }
        TownData data = (TownData)this.uuidMap.get(uuid);
        if (data == null || !data.hasBuilding(MINE.getResource())) {
            return Direction.MN_R0;
        }
        return data.getFacingFor(MINE.getResource());
    }

    @Override
    public int getMineIDFromCoordinates(BlockPos pos) {
        TownData data = this.getClosestTownToBlockPos(pos);
        if (data == null) {
            return -1;
        }
        if (!data.hasBuilding(MINE.getResource())) {
            return -1;
        }
        if (this.townIDs.containsKey((Object)data.getID())) {
            return (Integer)this.townIDs.get((Object)data.getID());
        }
        return this.matchUUIDWithMineID(data.getID());
    }

    private int matchUUIDWithMineID(UUID uuid) {
        for (int i = 0; i < 32000; ++i) {
            if (this.townIDs.inverse().containsKey((Object)i)) continue;
            this.townIDs.put((Object)uuid, (Object)i);
            HFTrackers.markDirty(this.getDimension());
            return i;
        }
        return 0;
    }

    public void createNewBuilder(BlockPos pos, TownDataServer data) {
        if (!data.isDead(HFNPCs.BUILDER)) {
            World world = this.getWorld();
            EntityNPCBuilder creator = new EntityNPCBuilder(world);
            creator.func_70634_a(pos.func_177958_n(), (double)pos.func_177956_o() + 1.5, pos.func_177952_p());
            creator.setSpawnHome(data);
            creator.func_184221_a(data.getID());
            world.func_72838_d((Entity)creator);
        }
    }

    @Override
    public TownData createNewTown(BlockPos pos, boolean builder) {
        World world = this.getWorld();
        TownDataServer data = new TownDataServer(pos);
        if (builder) {
            EntityNPCBuilder creator = new EntityNPCBuilder(world);
            creator.setSpawnHome(data);
            creator.func_184221_a(data.getID());
            creator.func_70634_a(pos.func_177958_n(), (double)pos.func_177956_o() + 1.5, pos.func_177952_p());
            world.func_72838_d((Entity)creator);
        }
        this.townData.add(data);
        this.closestCache.invalidateAll();
        this.uuidMap.put(data.getID(), data);
        this.matchUUIDWithMineID(data.getID());
        PacketHandler.sendToDimension(this.getDimension(), new PacketNewTown(data));
        HFTrackers.markDirty(this.getDimension());
        return data;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.townData = new HashSet();
        NBTTagList dimensionTowns = nbt.func_150295_c("Towns", 10);
        for (int j = 0; j < dimensionTowns.func_74745_c(); ++j) {
            NBTTagCompound tag = dimensionTowns.func_150305_b(j);
            TownDataServer theData = new TownDataServer();
            theData.readFromNBT(tag);
            this.uuidMap.put(theData.getID(), theData);
            this.townData.add(theData);
        }
        this.townIDs = HashBiMap.create();
        NBTTagList ids = nbt.func_150295_c("IDs", 10);
        for (int j = 0; j < ids.func_74745_c(); ++j) {
            NBTTagCompound tag = ids.func_150305_b(j);
            int id = tag.func_74762_e("ID");
            UUID uuid = UUID.fromString(tag.func_74779_i("UUID"));
            this.townIDs.put((Object)uuid, (Object)id);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList town_list = new NBTTagList();
        for (TownData data : this.townData) {
            NBTTagCompound townData = new NBTTagCompound();
            data.writeToNBT(townData);
            town_list.func_74742_a((NBTBase)townData);
        }
        nbt.func_74782_a("Towns", (NBTBase)town_list);
        NBTTagList ids = new NBTTagList();
        for (Map.Entry entry : this.townIDs.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("ID", ((Integer)entry.getValue()).intValue());
            tag.func_74778_a("UUID", ((UUID)entry.getKey()).toString());
            ids.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("IDs", (NBTBase)ids);
        return nbt;
    }
}

