/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import joshie.harvest.core.HFTracker;
import joshie.harvest.core.util.Direction;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.town.TownData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

public abstract class TownTracker
extends HFTracker {
    public static final TownData NULL_TOWN = new TownData().setUUID(UUID.fromString("5b529b64-62dc-35df-416c-05e0210f6ab0"));
    protected final Cache<BlockPos, TownData> closestCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(512L).build();
    protected final HashMap<UUID, TownData> uuidMap = new HashMap();
    protected Set<TownData> townData = new HashSet<TownData>();

    public TownData getClosestTownToBlockPos(BlockPos pos) {
        try {
            this.closestCache.cleanUp();
            return (TownData)this.closestCache.get((Object)pos, () -> {
                TownData closest = null;
                double thatTownDistance = Double.MAX_VALUE;
                for (TownData town : this.townData) {
                    double thisTownDistance = town.getTownCentre().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    if (closest != null && !(thisTownDistance < thatTownDistance)) continue;
                    thatTownDistance = thisTownDistance;
                    closest = town;
                }
                return thatTownDistance > HFNPCs.TOWN_DISTANCE || closest == null ? NULL_TOWN : closest;
            });
        }
        catch (Exception e) {
            return NULL_TOWN;
        }
    }

    public abstract TownData createNewTown(BlockPos var1, boolean var2);

    public TownData getTownByID(UUID townID) {
        TownData result = this.uuidMap.get(townID);
        return result == null ? NULL_TOWN : result;
    }

    public BlockPos getCoordinatesForOverworldMine(Entity entity, int mineID) {
        return entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_180470_cg() : entity.field_70170_p.func_175694_M();
    }

    public int getMineIDFromCoordinates(BlockPos pos) {
        return -1;
    }

    public Direction getMineOrientation(int mineID) {
        return Direction.MN_R0;
    }
}

