/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town;

import java.util.UUID;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownDataServer;
import joshie.harvest.town.TownTracker;
import joshie.harvest.town.TownTrackerServer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TownHelper {
    public static <T extends TownData> T getClosestTownToBlockPos(World world, BlockPos pos) {
        return (T)((TownTracker)HFTrackers.getTownTracker(world)).getClosestTownToBlockPos(pos);
    }

    public static <T extends TownData> T getClosestTownToEntity(EntityLivingBase entity) {
        return (T)((TownTracker)HFTrackers.getTownTracker(entity.field_70170_p)).getClosestTownToBlockPos(new BlockPos((Entity)entity));
    }

    public static TownData getTownByID(World world, UUID townID) {
        return ((TownTracker)HFTrackers.getTownTracker(world)).getTownByID(townID);
    }

    public static boolean ensureTownExists(World world, BlockPos pos) {
        TownDataServer server;
        boolean ret = true;
        TownTrackerServer tracker = (TownTrackerServer)HFTrackers.getTownTracker(world);
        TownData data = tracker.getClosestTownToBlockPos(pos);
        if (data == null || data == TownTracker.NULL_TOWN) {
            data = tracker.createNewTown(pos, true);
            ret = false;
        }
        if (data instanceof TownDataServer && (server = (TownDataServer)data).getBuilder((WorldServer)world) == null) {
            tracker.createNewBuilder(pos, server);
            return false;
        }
        return ret;
    }

    public static boolean createTownIfDoesntExist(World world, BlockPos pos) {
        TownTrackerServer tracker = (TownTrackerServer)HFTrackers.getTownTracker(world);
        TownData data = tracker.getClosestTownToBlockPos(pos);
        if (data == null || data == TownTracker.NULL_TOWN) {
            tracker.createNewTown(pos, false);
            return false;
        }
        return true;
    }
}

