/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingStage;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.gathering.GatheringData;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.NPCRegistry;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.npc.entity.EntityNPCHuman;
import joshie.harvest.town.TownData;
import joshie.harvest.town.packet.PacketSyncBuilding;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TownDataServer
extends TownData {
    public final GatheringData gathering = new GatheringData();
    private Set<ResourceLocation> deadVillagers = new HashSet<ResourceLocation>();

    public TownDataServer() {
    }

    public TownDataServer(BlockPos pos) {
        this.townCentre = pos;
        this.uuid = UUID.randomUUID();
    }

    public boolean isDead(INPC npc) {
        return this.deadVillagers.contains(((NPC)npc).getRegistryName());
    }

    public void markNPCDead(ResourceLocation name) {
        this.deadVillagers.add(name);
    }

    public EntityNPCBuilder getBuilder(WorldServer world) {
        return (EntityNPCBuilder)world.func_175733_a(this.getID());
    }

    public void syncBuildings(World world) {
        PacketHandler.sendToDimension(world.field_73011_w.getDimension(), new PacketSyncBuilding(this.getID(), this.building));
    }

    public boolean setBuilding(World world, BuildingImpl building, BlockPos pos, Mirror mirror, Rotation rotation) {
        BuildingStage stage = new BuildingStage(building, pos, mirror, rotation);
        if (!this.building.contains(stage)) {
            this.building.addLast(stage);
            HFTrackers.markDirty(world);
            this.syncBuildings(world);
            return true;
        }
        return false;
    }

    public void finishBuilding(World world) {
        this.building.removeFirst();
        HFTrackers.markDirty(world);
    }

    @Override
    public void newDay(World world) {
        if (world.func_175667_e(this.getTownCentre())) {
            this.gathering.newDay(world, this.buildings.values());
            for (ResourceLocation villager : this.deadVillagers) {
                NPC npc = (NPC)NPCRegistry.REGISTRY.getValue(villager);
                if (npc == HFNPCs.GODDESS) continue;
                EntityNPCHuman entity = (EntityNPCHuman)((Object)NPCHelper.getEntityForNPC(world, npc));
                entity.func_70107_b(this.townCentre.func_177958_n(), this.townCentre.func_177956_o(), this.townCentre.func_177952_p());
                entity.resetSpawnHome();
                BlockPos pos = entity.getHomeCoordinates();
                for (int attempts = 0; !EntityHelper.isSpawnable(world, pos) && attempts < 64; ++attempts) {
                    pos = pos.func_177982_a(world.field_73012_v.nextInt(16) - 8, world.field_73012_v.nextInt(8), world.field_73012_v.nextInt(16) - 8);
                }
                entity.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (npc == HFNPCs.BUILDER) {
                    entity.func_184221_a(this.getID());
                }
                world.func_72838_d((Entity)entity);
            }
            this.deadVillagers = new HashSet<ResourceLocation>();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.gathering.readFromNBT(nbt);
        this.deadVillagers = NBTHelper.readResourceSet(nbt, "DeadVillagers");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.gathering.writeToNBT(nbt);
        nbt.func_74782_a("DeadVillagers", (NBTBase)NBTHelper.writeResourceSet(this.deadVillagers));
    }
}

