/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town;

import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.entities.PlaceableNPC;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.util.Direction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TownBuilding {
    public BuildingImpl building;
    public Direction direction;
    public BlockPos pos;

    public TownBuilding() {
    }

    public TownBuilding(BuildingImpl building, Direction direction, BlockPos pos) {
        this.building = building;
        this.direction = direction;
        this.pos = pos;
    }

    public Direction getFacing() {
        return this.direction;
    }

    public BlockPos getRealCoordinatesFor(Placeable placeable) {
        return placeable.getTransformedPosition(this.pos, this.direction);
    }

    public BlockPos getRealCoordinatesFor(String npc_location) {
        PlaceableNPC offsets = this.building.getNPCOffset(npc_location);
        if (offsets == null) {
            return null;
        }
        return this.getRealCoordinatesFor(offsets);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.building = (BuildingImpl)BuildingRegistry.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("Building")));
        this.direction = Direction.valueOf(nbt.func_74779_i("Direction"));
        this.pos = NBTHelper.readBlockPos("Building", nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("Building", BuildingRegistry.REGISTRY.getKey((IForgeRegistryEntry)this.building).toString());
        nbt.func_74778_a("Direction", this.direction.name());
        NBTHelper.writeBlockPos("Building", nbt, this.pos);
    }
}

