/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.tools.item;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.base.item.ItemTool;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.crops.block.BlockHFCrops;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWateringCan
extends ItemTool<ItemWateringCan>
implements IFluidContainerItem {
    public ItemWateringCan() {
        super("watering_can", new HashSet<Block>());
    }

    @Override
    public int getFront(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: 
            case COPPER: {
                return 0;
            }
            case SILVER: {
                return 1;
            }
            case GOLD: {
                return 2;
            }
            case MYSTRIL: {
                return 4;
            }
            case CURSED: 
            case BLESSED: {
                return 6;
            }
            case MYTHIC: {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public int getSides(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: {
                return 0;
            }
            case COPPER: 
            case SILVER: 
            case GOLD: {
                return 1;
            }
            case MYSTRIL: {
                return 2;
            }
            case CURSED: 
            case BLESSED: {
                return 6;
            }
            case MYTHIC: {
                return 10;
            }
        }
        return 0;
    }

    @Override
    public boolean canBeDamaged() {
        return false;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o()) {
            byte water = stack.func_77978_p().func_74771_c("Water");
            return (128.0 - (double)water) / 128.0;
        }
        return 0.0;
    }

    public FluidStack getFluid(ItemStack container) {
        return container.func_77942_o() ? new FluidStack(FluidRegistry.WATER, (int)container.func_77978_p().func_74771_c("Water")) : null;
    }

    public int getCapacity(ItemStack container) {
        return container.func_77942_o() ? (int)container.func_77978_p().func_74771_c("Water") : 0;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        byte current_capacity;
        int max_fill_capacity;
        if (resource == null || resource.getFluid() != FluidRegistry.WATER) {
            return 0;
        }
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        int amount_filled = resource.amount >= (max_fill_capacity = Math.max(0, 127 - (current_capacity = container.func_77978_p().func_74771_c("Water")))) ? max_fill_capacity : resource.amount;
        int new_amount = current_capacity + amount_filled;
        if (doFill) {
            container.func_77978_p().func_74774_a("Water", (byte)new_amount);
        }
        return amount_filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (maxDrain == 1 && container.func_77942_o()) {
            byte water = container.func_77978_p().func_74771_c("Water");
            if (water >= 1) {
                if (doDrain) {
                    container.func_77978_p().func_74774_a("Water", (byte)(water - 1));
                }
                return new FluidStack(FluidRegistry.WATER, 1);
            }
            return null;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.attemptToFill(world, player, stack)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        this.waterCrops(world, player, this.getMovingObjectPositionFromPlayer(world, (EntityLivingBase)player), stack, this.getTier(stack));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private EnumActionResult hydrate(EntityPlayer player, ItemStack stack, World world, BlockPos pos) {
        if (HFApi.crops.hydrateSoil(player, world, pos)) {
            this.displayParticle(world, pos, EnumParticleTypes.WATER_SPLASH, Blocks.field_150355_j.func_176223_P());
            this.playSound(world, pos, SoundEvents.field_187549_bG, SoundCategory.NEUTRAL);
            ToolHelper.performTask(player, stack, this.getExhaustionRate(stack));
            if (!player.field_71075_bZ.field_75098_d) {
                this.drain(stack, 1, true);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private boolean attemptToFill(World world, EntityPlayer player, ItemStack stack) {
        IBlockState state;
        RayTraceResult rayTraceResult = this.func_77621_a(world, player, true);
        if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(rayTraceResult.func_178782_a())).func_185904_a() == Material.field_151586_h) {
            return this.fill(stack, new FluidStack(FluidRegistry.WATER, 128), true) > 0;
        }
        return false;
    }

    protected void waterCrops(World world, EntityPlayer player, @Nullable RayTraceResult result, ItemStack stack, ITiered.ToolTier tier) {
        if (result != null) {
            BlockPos pos = result.func_178782_a();
            EnumFacing front = EntityHelper.getFacingFromEntity((EntityLivingBase)player);
            Block initial = world.func_180495_p(pos).func_177230_c();
            if (!(initial instanceof BlockFarmland) && !(initial instanceof IPlantable)) {
                return;
            }
            for (int y2 = pos.func_177956_o() - 1; y2 <= pos.func_177956_o(); ++y2) {
                for (int x2 = this.getXMinus(tier, front, pos.func_177958_n()); x2 <= this.getXPlus(tier, front, pos.func_177958_n()); ++x2) {
                    for (int z2 = this.getZMinus(tier, front, pos.func_177952_p()); z2 <= this.getZPlus(tier, front, pos.func_177952_p()); ++z2) {
                        if (this.getCapacity(stack) <= 0 || !this.canUse(stack)) continue;
                        BlockPos position = new BlockPos(x2, y2, z2);
                        IBlockState state = world.func_180495_p(position);
                        IStateHandler.PlantSection section = BlockHFCrops.getSection(state);
                        if (section != null) {
                            int down = section == IStateHandler.PlantSection.BOTTOM ? 1 : 2;
                            this.hydrate(player, stack, world, position.func_177979_c(down));
                            continue;
                        }
                        if (!(state.func_177230_c() instanceof BlockFarmland)) continue;
                        this.hydrate(player, stack, world, position);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (advanced && HFCore.DEBUG_MODE) {
            tooltip.add("Water: " + this.getCapacity(stack));
            tooltip.add("Level: " + this.getLevel(stack));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < ITiered.ToolTier.values().length; ++i) {
            ItemStack unleveled = new ItemStack(item, 1, i);
            this.fill(unleveled, new FluidStack(FluidRegistry.WATER, 128), true);
            list.add(unleveled);
        }
    }
}

