/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.tools.item;

import com.google.common.collect.Multimap;
import java.util.HashSet;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.crops.IBreakCrops;
import joshie.harvest.core.base.item.ItemTool;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.crops.block.BlockHFCrops;
import joshie.harvest.tools.ToolHelper;
import joshie.harvest.tools.item.ItemHoe;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemSickle
extends ItemTool<ItemHoe>
implements IBreakCrops {
    public ItemSickle() {
        super("sickle", new HashSet<Block>());
    }

    @Override
    public int getFront(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: 
            case COPPER: {
                return 0;
            }
            case SILVER: {
                return 1;
            }
            case GOLD: {
                return 2;
            }
            case MYSTRIL: {
                return 4;
            }
            case CURSED: 
            case BLESSED: {
                return 8;
            }
            case MYTHIC: {
                return 14;
            }
        }
        return 0;
    }

    @Override
    public int getSides(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: {
                return 0;
            }
            case COPPER: 
            case SILVER: 
            case GOLD: {
                return 1;
            }
            case MYSTRIL: {
                return 2;
            }
            case CURSED: 
            case BLESSED: {
                return 4;
            }
            case MYTHIC: {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        return state.func_177230_c() != Blocks.field_150349_c && material == Material.field_151577_b || material == Material.field_151584_j || material == Material.field_151582_l ? 10.0f : super.func_150893_a(stack, state);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        ITiered.ToolTier tier = this.getTier(stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 3.0 + ((double)tier.getToolLevel() - 6.0), 0));
        }
        return multimap;
    }

    @Override
    public float getStrengthVSCrops(EntityPlayer player, World world, BlockPos pos, IBlockState state, ItemStack stack) {
        if (!player.func_175151_a(pos, EnumFacing.DOWN, stack)) {
            return 0.0f;
        }
        EnumFacing front = EntityHelper.getFacingFromEntity((EntityLivingBase)player);
        Block initial = world.func_180495_p(pos).func_177230_c();
        if (!(initial instanceof BlockHFCrops)) {
            return 0.0f;
        }
        ITiered.ToolTier tier = this.getTier(stack);
        for (int x2 = this.getXMinus(tier, front, pos.func_177958_n()); x2 <= this.getXPlus(tier, front, pos.func_177958_n()); ++x2) {
            for (int z2 = this.getZMinus(tier, front, pos.func_177952_p()); z2 <= this.getZPlus(tier, front, pos.func_177952_p()); ++z2) {
                boolean isWithered;
                BlockPos newPos;
                Block block;
                if (!this.canUse(stack) || !((block = world.func_180495_p(newPos = new BlockPos(x2, pos.func_177956_o(), z2)).func_177230_c()) instanceof BlockHFCrops)) continue;
                if (!world.field_72995_K && !newPos.equals((Object)pos)) {
                    block.removedByPlayer(state, world, newPos, player, true);
                }
                IBlockState particleState = (isWithered = BlockHFCrops.isWithered(world.func_180495_p(newPos))) ? Blocks.field_150329_H.func_176223_P() : Blocks.field_150459_bM.func_176223_P();
                this.displayParticle(world, newPos, EnumParticleTypes.BLOCK_CRACK, particleState);
                this.playSound(world, newPos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS);
                ToolHelper.performTask(player, stack, this.getExhaustionRate(stack));
            }
        }
        return 1.0f;
    }
}

