/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.tools.item;

import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.core.base.item.ItemToolChargeable;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.util.Text;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHoe
extends ItemToolChargeable {
    public ItemHoe() {
        super("hoe", new HashSet<Block>());
    }

    @Override
    public int getFront(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: {
                return 0;
            }
            case COPPER: {
                return 1;
            }
            case SILVER: {
                return 2;
            }
            case GOLD: {
                return 3;
            }
            case MYSTRIL: {
                return 5;
            }
            case CURSED: 
            case BLESSED: {
                return 11;
            }
            case MYTHIC: {
                return 17;
            }
        }
        return 0;
    }

    @Override
    public int getSides(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: 
            case COPPER: 
            case SILVER: 
            case GOLD: 
            case MYSTRIL: {
                return 0;
            }
            case CURSED: 
            case BLESSED: {
                return 1;
            }
            case MYTHIC: {
                return 2;
            }
        }
        return 0;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        ITiered.ToolTier tier = this.getTier(stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 3.0 + (double)((float)tier.getToolLevel() - 6.0f), 0));
        }
        return multimap;
    }

    protected void setBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        this.doParticles(stack, player, world, pos);
        if (!world.field_72995_K) {
            world.func_180501_a(pos, state, 11);
        }
    }

    private int onHoeUse(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos) {
        UseHoeEvent event = new UseHoeEvent(player, stack, worldIn, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            this.displayParticle(worldIn, pos, EnumParticleTypes.BLOCK_CRACK, Blocks.field_150346_d.func_176223_P());
            this.playSound(worldIn, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS);
            ToolHelper.performTask(player, stack, this.getExhaustionRate(stack));
            return 1;
        }
        return 0;
    }

    private EnumActionResult getHoeResult(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing facing) {
        boolean allowed;
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        int hook = this.onHoeUse(stack, playerIn, worldIn, pos);
        if (hook != 0) {
            if (hook > 0) {
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        boolean bl = allowed = worldIn.func_175623_d(pos.func_177984_a()) || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof IPlantable;
        if (facing != EnumFacing.DOWN && allowed) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                this.setBlock(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                return EnumActionResult.SUCCESS;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        this.setBlock(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                        return EnumActionResult.SUCCESS;
                    }
                    case COARSE_DIRT: {
                        this.setBlock(stack, playerIn, worldIn, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        return EnumActionResult.PASS;
    }

    private boolean canHoe(EntityPlayer player, ItemStack stack, World world, BlockPos pos) {
        if (HFCrops.DISABLE_VANILLA_HOE) {
            return true;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack.func_77946_l(), world, pos);
        event.setResult(Event.Result.ALLOW);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        return event.getResult() != Event.Result.DENY;
    }

    @Override
    protected void onFinishedCharging(World world, EntityLivingBase entity, @Nullable RayTraceResult result, ItemStack stack, ITiered.ToolTier tier) {
        EnumFacing front;
        BlockPos pos;
        EntityPlayer player;
        if (result != null && entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_175151_a((pos = result.func_178782_a()).func_177972_a(front = EntityHelper.getFacingFromEntity((EntityLivingBase)player)), front, stack) && this.canUse(stack)) {
            for (int x2 = this.getXMinus(tier, front, pos.func_177958_n()); x2 <= this.getXPlus(tier, front, pos.func_177958_n()); ++x2) {
                for (int z2 = this.getZMinus(tier, front, pos.func_177952_p()); z2 <= this.getZPlus(tier, front, pos.func_177952_p()); ++z2) {
                    if (!this.canUse(stack)) continue;
                    BlockPos newPos = new BlockPos(x2, pos.func_177956_o(), z2);
                    this.getHoeResult(stack, player, world, newPos, EnumFacing.UP);
                }
            }
        }
    }

    private void doParticles(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        this.displayParticle(world, pos, EnumParticleTypes.BLOCK_CRACK, Blocks.field_150346_d.func_176223_P());
        this.playSound(world, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS);
        ToolHelper.performTask(player, stack, this.getExhaustionRate(stack));
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockBush) {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        super.func_77624_a(stack, player, list, flag);
        int charge = this.getCharge(stack);
        ITiered.ToolTier tier = (ITiered.ToolTier)((Object)LEVEL_TO_TIER.get(charge));
        ITiered.ToolTier thisTier = this.getTier(stack);
        list.add(TextFormatting.GOLD + Text.translate("hoe.tooltip.charge." + tier.name().toLowerCase(Locale.ENGLISH)));
        list.add("-------");
        if (charge < thisTier.getToolLevel()) {
            list.add(TextFormatting.AQUA + "" + TextFormatting.ITALIC + Text.translate("hoe.tooltip.charge"));
        }
        if (charge != 0) {
            list.add(TextFormatting.RED + "" + TextFormatting.ITALIC + Text.translate("hoe.tooltip.discharge"));
        }
    }

    @Override
    protected String getLevelName(ItemStack stack, int charges) {
        int newCharge;
        int maximum = this.getMaxCharge(stack);
        int charge = this.getCharge(stack);
        return charge == (newCharge = Math.min(maximum, charge + charges)) ? null : Text.translate("hoe.tooltip.charge." + ((ITiered.ToolTier)((Object)LEVEL_TO_TIER.get(newCharge))).name().toLowerCase(Locale.ENGLISH));
    }
}

