/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.tools.item;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.gathering.ISmashable;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemToolSmashing;
import joshie.harvest.core.lib.HFSounds;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemHammer
extends ItemToolSmashing {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});
    private static final double[] ATTACK_DAMAGES = new double[]{3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 5.5, 6.0};

    public ItemHammer() {
        super("pickaxe", EFFECTIVE_ON);
        this.func_77637_a(HFTab.MINING);
    }

    @Override
    public ISmashable.ToolType getToolType() {
        return ISmashable.ToolType.HAMMER;
    }

    @Override
    public void playSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, HFSounds.SMASH_ROCK, SoundCategory.BLOCKS, world.field_73012_v.nextFloat() * 0.45f, world.field_73012_v.nextFloat() * 1.0f + 0.5f);
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.canUse(stack)) {
            Material material = state.func_185904_a();
            return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? super.func_150893_a(stack, state) : this.getEffiency(stack);
        }
        return 0.1f;
    }

    @Override
    public boolean onSmashed(EntityPlayer player, ItemStack stack, ITiered.ToolTier tier, int harvestLevel, World world, BlockPos pos, IBlockState state) {
        if (this.canUse(stack) && state.func_177230_c() == Blocks.field_150458_ak) {
            ToolHelper.performTask(player, stack, this.getExhaustionRate(stack));
            return world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        }
        return super.onSmashed(player, stack, tier, harvestLevel, world, pos, state);
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{this.func_77640_w(), HFTab.GATHERING};
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        ITiered.ToolTier tier = this.getTier(stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", ATTACK_DAMAGES[tier.ordinal()], 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.0, 0));
        }
        return multimap;
    }
}

