/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.tools.item;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.gathering.ISmashable;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemToolSmashing;
import joshie.harvest.core.lib.HFSounds;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemAxe
extends ItemToolSmashing {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw});
    private static final float[] ATTACK_SPEEDS = new float[]{-3.2f, -3.1f, -3.1f, -3.0f, -3.0f, -2.9f, -2.9f, -2.8f};

    public ItemAxe() {
        super("axe", EFFECTIVE_ON);
        this.func_77637_a(HFTab.GATHERING);
    }

    @Override
    public ISmashable.ToolType getToolType() {
        return ISmashable.ToolType.AXE;
    }

    @Override
    public void playSound(World world, BlockPos pos) {
        this.playSound(world, pos, HFSounds.SMASH_WOOD, SoundCategory.BLOCKS);
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.canUse(stack)) {
            Material material = state.func_185904_a();
            return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l ? super.func_150893_a(stack, state) : this.getEffiency(stack);
        }
        return 0.1f;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        ITiered.ToolTier tier = this.getTier(stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(tier == ITiered.ToolTier.BASIC ? 6.0f : 8.0f), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)ATTACK_SPEEDS[tier.ordinal()], 0));
        }
        return multimap;
    }
}

