/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.tools;

import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.item.ItemAnimalTool;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.cooking.item.ItemIngredients;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.item.ItemNPCTool;
import joshie.harvest.tools.HFTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ToolHelper {
    public static boolean isMilker(ItemStack stack) {
        return HFAnimals.TOOLS.getEnumFromStack(stack) == ItemAnimalTool.Tool.MILKER;
    }

    public static boolean isBrush(ItemStack stack) {
        return HFAnimals.TOOLS.getEnumFromStack(stack) == ItemAnimalTool.Tool.BRUSH;
    }

    public static boolean isBlueFeather(ItemStack stack) {
        return HFNPCs.TOOLS.getEnumFromStack(stack) == ItemNPCTool.NPCTool.BLUE_FEATHER;
    }

    public static boolean isEgg(ItemStack stack) {
        return HFAnimals.EGG.matches(stack);
    }

    public static boolean isOil(ItemStack stack) {
        return HFCooking.INGREDIENTS.getEnumFromStack(stack) == ItemIngredients.Ingredient.OIL;
    }

    public static boolean isKnife(ItemStack stack) {
        return HFApi.cooking.isKnife(stack);
    }

    public static void levelTool(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() instanceof ITiered) {
            ((ITiered)stack.func_77973_b()).levelTool(stack);
        }
    }

    public static void performTask(EntityPlayer player, ItemStack stack, float amount) {
        ToolHelper.levelTool(stack);
        if (player.field_71075_bZ.field_75098_d || !HFTools.HF_CONSUME_HUNGER) {
            return;
        }
        ToolHelper.consumeHunger(player, amount);
        stack.func_179543_a("Data", true).func_74768_a("Damage", stack.func_179543_a("Data", true).func_74762_e("Damage") + 1);
    }

    public static void consumeHunger(EntityPlayer player, float amount) {
        if (player == null) {
            return;
        }
        int level = player.func_71024_bL().func_75116_a();
        if (amount > 0.0f) {
            player.func_71024_bL().func_75113_a(HFTools.EXHAUSTION_AMOUNT * amount);
        }
        if (level > 2 && level <= 6) {
            player.func_184589_d(HFTools.EXHAUSTION);
            player.func_70690_d(new PotionEffect(HFTools.FATIGUE, 6000));
        } else if (level <= 2 && !player.func_70644_a(HFTools.EXHAUSTION)) {
            player.func_184589_d(HFTools.FATIGUE);
            player.func_70690_d(new PotionEffect(HFTools.EXHAUSTION, 2000));
        } else {
            PotionEffect effect = player.func_70660_b(HFTools.EXHAUSTION);
            if (level == 0 || effect != null && effect.func_76459_b() <= 1500) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 7));
                if (!player.field_70170_p.field_72995_K) {
                    int dimension = player.field_70170_p.field_73011_w.func_76567_e() ? player.field_70170_p.field_73011_w.getDimension() : 0;
                    BlockPos spawn = player.getBedLocation(dimension) != null ? player.getBedLocation(dimension) : DimensionManager.getWorld((int)dimension).field_73011_w.getRandomizedSpawnPoint();
                    EntityHelper.teleport((Entity)player, dimension, spawn);
                    player.func_180469_a(spawn);
                }
                player.func_184589_d(HFTools.FATIGUE);
                player.func_184589_d(HFTools.EXHAUSTION);
                if (HFTools.RESTORE_HUNGER_ON_FAINTING) {
                    ToolHelper.restoreHunger(player);
                }
            }
        }
    }

    public static void restoreHunger(EntityPlayer player) {
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)player.func_71024_bL(), (Object)20, (String[])new String[]{"foodLevel", "field_75127_a"});
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)player.func_71024_bL(), (Object)Float.valueOf(5.0f), (String[])new String[]{"foodSaturationLevel", "field_75125_b"});
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)player.func_71024_bL(), (Object)0, (String[])new String[]{"foodExhaustionLevel", "field_75126_c"});
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)player.func_71024_bL(), (Object)0, (String[])new String[]{"foodTimer", "field_75123_d"});
    }

    @HFEvents
    public static class RestoreHungerOnSleep {
        public static boolean register() {
            return HFTools.RESTORE_HUNGER_ON_SLEEP;
        }

        @SubscribeEvent
        public void onWakeup(PlayerWakeUpEvent event) {
            EntityPlayer player = event.getEntityPlayer();
            if (player.field_70170_p.func_72820_D() % HFCalendar.TICKS_PER_DAY == 0L) {
                if (player.func_70644_a(HFTools.EXHAUSTION)) {
                    player.func_184589_d(HFTools.EXHAUSTION);
                }
                if (player.func_70644_a(HFTools.FATIGUE)) {
                    player.func_184589_d(HFTools.FATIGUE);
                }
                ToolHelper.restoreHunger(player);
            }
        }
    }
}

