/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.tools;

import joshie.harvest.api.HFApi;
import joshie.harvest.core.base.item.ItemTool;
import joshie.harvest.core.base.item.ItemToolChargeable;
import joshie.harvest.core.base.item.ItemToolSmashing;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.helpers.RegistryHelper;
import joshie.harvest.core.util.HFLoader;
import joshie.harvest.tools.HFPotion;
import joshie.harvest.tools.item.ItemAxe;
import joshie.harvest.tools.item.ItemHammer;
import joshie.harvest.tools.item.ItemHoe;
import joshie.harvest.tools.item.ItemSickle;
import joshie.harvest.tools.item.ItemWateringCan;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

@HFLoader
public class HFTools {
    public static final ItemToolSmashing HAMMER = (ItemToolSmashing)new ItemHammer().register("hammer");
    public static final ItemToolSmashing AXE = (ItemToolSmashing)new ItemAxe().register("axe");
    public static final ItemTool SICKLE = (ItemTool)new ItemSickle().register("sickle");
    public static final ItemToolChargeable HOE = (ItemToolChargeable)new ItemHoe().register("hoe");
    public static final ItemWateringCan WATERING_CAN = (ItemWateringCan)new ItemWateringCan().register("wateringcan");
    public static final Potion FATIGUE = HFTools.registerPotion("fatigue", 0xD9D900, 0, 0).func_111184_a(SharedMonsterAttributes.field_111263_d, "8107BC5E-7CF8-4030-440C-514C1F160890", -0.10000000596046447, 2);
    public static final Potion EXHAUSTION = HFTools.registerPotion("exhaustion", 0xBBBBBB, 1, 0).func_111184_a(SharedMonsterAttributes.field_111263_d, "8107BC5D-5CF8-4030-440C-314C1E160890", -0.5000000059604645, 2).func_111184_a(SharedMonsterAttributes.field_188790_f, "8107BC5D-5CF8-4030-440C-314C1E160891", -0.5000000059604645, 2);
    public static final Potion CURSED = HFTools.registerPotion("cursed", 0x660000, 2, 0).func_111184_a(SharedMonsterAttributes.field_111267_a, "FB353E1C-4180-4865-B01B-BCCE9785ACA3", -0.18, 2).func_111184_a(SharedMonsterAttributes.field_111263_d, "8107BD5E-7CF8-4030-441C-514C1F160890", -0.02500000596046448, 2).func_111184_a(SharedMonsterAttributes.field_111264_e, "8107BD5F-4CF8-4030-441D-534C1F140890", (double)-0.15f, 2);
    public static float EXHAUSTION_AMOUNT;
    public static boolean RESTORE_HUNGER_ON_SLEEP;
    public static boolean RESTORE_HUNGER_ON_FAINTING;
    public static boolean HF_CONSUME_HUNGER;
    public static boolean ATTACK_FAINTING;
    public static boolean BLOCK_FAINTING;

    public static void preInit() {
        RegistryHelper.registerSounds("smash_rock", "smash_wood");
    }

    public static void init() {
        HFApi.npc.getGifts().addToBlacklist(HAMMER, AXE, SICKLE, WATERING_CAN, HOE);
    }

    private static Potion registerPotion(String name, int color, int x, int y) {
        ResourceLocation location = new ResourceLocation("harvestfestival", name);
        Potion potion = (Potion)new HFPotion("harvestfestival.effect." + name, color, x, y).setRegistryName(location);
        return (Potion)GameRegistry.register((IForgeRegistryEntry)potion);
    }

    public static void configure() {
        EXHAUSTION_AMOUNT = 4.0f / (float)ConfigHelper.getInteger("Actions per half haunch", 27);
        RESTORE_HUNGER_ON_SLEEP = ConfigHelper.getBoolean("Restore hunger on sleep", true);
        RESTORE_HUNGER_ON_SLEEP = ConfigHelper.getBoolean("Restore hunger on fainting", true);
        HF_CONSUME_HUNGER = ConfigHelper.getBoolean("Performing Harvest Festival actions consumes hunger", true);
        ATTACK_FAINTING = ConfigHelper.getBoolean("Attack entities has chance of fainting", false);
        BLOCK_FAINTING = ConfigHelper.getBoolean("Breaking blocks has chance of fainting", false);
    }
}

