/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.purchasable;

import joshie.harvest.api.HFApi;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.shops.purchasable.Purchasable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PurchasableWeekend
extends Purchasable {
    private final ItemStack[] required;

    public PurchasableWeekend(long cost, ItemStack stack, ItemStack ... required) {
        super(cost, stack);
        this.required = required;
    }

    private boolean hasRequiredItem(EntityPlayer player) {
        if (this.required == null || this.required.length == 0) {
            return true;
        }
        for (ItemStack stack : this.required) {
            if (((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getTracking().hasObtainedItem(stack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBuy(World world, EntityPlayer player) {
        return HFApi.calendar.getDate(world).getWeekday().isWeekend() && this.hasRequiredItem(player);
    }

    @Override
    public boolean onPurchased(EntityPlayer player) {
        ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getTracking().addAsObtained(this.stacks[0]);
        return super.onPurchased(player);
    }
}

