/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.purchasable;

import java.util.List;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.core.helpers.SpawnItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PurchasableFML<I extends IForgeRegistryEntry.Impl<I>>
implements IPurchasable {
    protected I item;
    private final long cost;

    public PurchasableFML(long cost, ResourceLocation resource) {
        this.cost = cost;
        if (resource != null) {
            this.item = (IForgeRegistryEntry.Impl)this.getRegistry().getValue(resource);
        }
    }

    public abstract IForgeRegistry<I> getRegistry();

    @Override
    public boolean canBuy(World world, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canList(World world, EntityPlayer player) {
        return this.canBuy(world, player);
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public boolean onPurchased(EntityPlayer player) {
        SpawnItemHelper.addToPlayerInventory(player, this.getDisplayStack().func_77946_l());
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltip(List<String> list) {
        list.add(TextFormatting.WHITE + this.getDisplayStack().func_82833_r());
    }

    @Override
    public String getPurchaseableID() {
        return this.item.getRegistryName().toString().replace(":", "_");
    }
}

