/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.purchasable;

import java.util.List;
import java.util.Locale;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.util.Text;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class PurchasableEntity
implements IPurchasable {
    private final String resource;
    private final ItemStack product;
    private final Class<? extends Entity> eClass;
    private final long cost;
    private final boolean lead;

    public PurchasableEntity(Class<? extends Entity> clazz, long cost, ItemStack render, boolean lead) {
        this.product = render;
        this.eClass = clazz;
        this.cost = cost;
        this.lead = lead;
        this.resource = clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean canBuy(World world, EntityPlayer player) {
        if (!this.lead) {
            return player.func_184188_bt().size() == 0;
        }
        return true;
    }

    @Override
    public boolean canList(World world, EntityPlayer player) {
        return this.canBuy(world, player);
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.product;
    }

    @Override
    public void addTooltip(List<String> list) {
        list.add(TextFormatting.WHITE + this.product.func_82833_r());
        if (!this.lead) {
            list.add(Text.translate("check.head"));
        } else {
            list.add(Text.translate("check.lead"));
        }
    }

    public EntityLiving createEntity(World world) {
        EntityLiving entity = null;
        try {
            if (this.eClass != null) {
                entity = (EntityLiving)this.eClass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    @Override
    public boolean onPurchased(EntityPlayer aPlayer) {
        if (!aPlayer.field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)aPlayer;
            EntityLiving theEntity = this.createEntity(player.field_70170_p);
            if (theEntity != null) {
                theEntity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                if (!this.lead) {
                    theEntity.func_184205_a((Entity)player, true);
                } else {
                    theEntity.func_110162_b((Entity)player, true);
                }
                ((IAnimalTracked)theEntity).getData().setOwner(EntityHelper.getPlayerUUID((EntityPlayer)player));
                player.field_70170_p.func_72838_d((Entity)theEntity);
                if (!this.lead) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketSetPassengers((Entity)player));
                } else {
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityAttach((Entity)theEntity, theEntity.func_110166_bE()));
                }
            }
        }
        return false;
    }

    @Override
    public String getPurchaseableID() {
        return this.resource;
    }
}

