/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.purchasable;

import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.helpers.SpawnItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PurchasableCropSeeds
implements IPurchasable {
    private final String resource;
    private final Crop crop;

    public PurchasableCropSeeds(Crop crop) {
        this.crop = crop;
        this.resource = crop.getRegistryName().toString().replace(":", "_") + "Seeds";
    }

    private boolean isCorrectSeason(Season theSeason) {
        for (Season season : this.crop.getSeasons()) {
            if (season != theSeason) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBuy(World world, EntityPlayer player) {
        CalendarDate date = HFApi.calendar.getDate(world);
        if (!this.isCorrectSeason(date.getSeason())) {
            return false;
        }
        if (!this.crop.canPurchase()) {
            return false;
        }
        if (this.crop.getPurchaseYear() > 0) {
            return CalendarHelper.haveYearsPassed(world, player, this.crop.getPurchaseYear());
        }
        return true;
    }

    @Override
    public boolean canList(World world, EntityPlayer player) {
        return this.canBuy(world, player);
    }

    @Override
    public long getCost() {
        return this.crop.getSeedCost();
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.crop.getSeedStack(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltip(List<String> list) {
        list.addAll(this.getDisplayStack().func_82840_a((EntityPlayer)MCClientHelper.getPlayer(), false));
    }

    @Override
    public boolean onPurchased(EntityPlayer player) {
        SpawnItemHelper.addToPlayerInventory(player, this.crop.getSeedStack(1).func_77946_l());
        return false;
    }

    @Override
    public String getPurchaseableID() {
        return this.resource;
    }
}

