/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.purchasable;

import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.shops.purchasable.PurchasableBuilder;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import joshie.harvest.town.TownTracker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class PurchasableBuilding
extends PurchasableBuilder {
    private final ResourceLocation resource;
    private final BuildingImpl building;

    public PurchasableBuilding(BuildingImpl building) {
        super(building.getCost(), building.getWoodCount(), building.getStoneCount(), building.getRegistryName());
        this.building = building;
        this.resource = BuildingRegistry.REGISTRY.getKey((IForgeRegistryEntry)building);
    }

    @Override
    public ItemStack getDisplayStack() {
        return HFBuildings.CHEAT_BUILDINGS ? this.building.getSpawner() : this.building.getBlueprint();
    }

    @Override
    public boolean isPurchaseable(World world, EntityPlayer player) {
        Object town = TownHelper.getClosestTownToEntity((EntityLivingBase)player);
        if (((TownData)town).hasBuilding(this.resource)) {
            return false;
        }
        return this.building.getRules().canBuy(world, player) && this.building.hasRequirements(player);
    }

    @Override
    public boolean canList(World world, EntityPlayer player) {
        return !((TownTracker)HFTrackers.getTownTracker(world)).getClosestTownToBlockPos(new BlockPos((Entity)player)).hasBuilding(this.resource) && this.building.getRules().canBuy(world, player) && this.building.hasRequirements(player);
    }

    @Override
    public String getName() {
        return this.building.getLocalisedName();
    }
}

