/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.purchasable;

import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.shops.purchasable.Purchasable;
import joshie.harvest.shops.purchasable.PurchasableFML;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistry;

public class PurchasableBuilder
extends PurchasableFML<BuildingImpl> {
    private final String resource;
    private ItemStack stack;
    private final int logs;
    private final int stone;

    public PurchasableBuilder(long cost, int logs, int stone, ResourceLocation name) {
        super(cost, name);
        this.logs = logs;
        this.stone = stone;
        this.resource = name.toString().replace(":", "_");
    }

    public PurchasableBuilder(long cost, int logs, int stone, ItemStack stack) {
        super(cost, null);
        this.logs = logs;
        this.stone = stone;
        this.stack = stack;
        this.resource = Purchasable.stackToString(stack);
    }

    @Override
    public IForgeRegistry<BuildingImpl> getRegistry() {
        return BuildingRegistry.REGISTRY;
    }

    @Override
    public boolean canBuy(World world, EntityPlayer player) {
        if (!InventoryHelper.hasInInventory(player, InventoryHelper.ORE_DICTIONARY, "logWood", this.getLogCost())) {
            return false;
        }
        if (!InventoryHelper.hasInInventory(player, InventoryHelper.ORE_DICTIONARY, "stone", this.getStoneCost())) {
            return false;
        }
        return this.isPurchaseable(world, player);
    }

    @Override
    public boolean canList(World world, EntityPlayer player) {
        return true;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.stack != null ? this.stack : HFBuildings.BLUEPRINTS.getStackFromObject(this.item);
    }

    @Override
    public boolean onPurchased(EntityPlayer player) {
        InventoryHelper.takeItemsInInventory(player, InventoryHelper.ORE_DICTIONARY, "logWood", this.getLogCost());
        InventoryHelper.takeItemsInInventory(player, InventoryHelper.ORE_DICTIONARY, "stone", this.getStoneCost());
        return super.onPurchased(player);
    }

    public boolean isPurchaseable(World world, EntityPlayer player) {
        return true;
    }

    public int getLogCost() {
        return this.logs;
    }

    public int getStoneCost() {
        return this.stone;
    }

    public String getName() {
        return this.stack != null ? this.stack.func_82833_r() : this.getDisplayStack().func_82833_r();
    }

    @Override
    public String getPurchaseableID() {
        return this.resource;
    }
}

