/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.purchasable;

import java.util.List;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.helpers.SpawnItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Purchasable
implements IPurchasable {
    protected final ItemStack[] stacks;
    private final String resource;
    private final long cost;

    public Purchasable(long cost, ItemStack ... stacks) {
        this.cost = cost;
        this.stacks = stacks;
        StringBuilder builder = new StringBuilder();
        for (ItemStack stack : stacks) {
            builder.append(Purchasable.stackToString(stack));
        }
        this.resource = builder.toString();
    }

    static String stackToString(ItemStack stack) {
        if (stack == null) {
            return "null";
        }
        String string = stack.func_77973_b().getRegistryName().toString().replace(":", "_");
        if (stack.func_77952_i() != 0) {
            string = string + "_" + stack.func_77952_i();
        }
        if (stack.func_77978_p() != null) {
            string = string + "_" + stack.func_77978_p().hashCode();
        }
        return string;
    }

    @Override
    public boolean canBuy(World world, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canList(World world, EntityPlayer player) {
        return this.canBuy(world, player);
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.stacks[0];
    }

    @Override
    public boolean onPurchased(EntityPlayer player) {
        for (ItemStack product : this.stacks) {
            SpawnItemHelper.addToPlayerInventory(player, product.func_77946_l());
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltip(List<String> list) {
        for (ItemStack stack : this.stacks) {
            if (stack == null) continue;
            list.addAll(stack.func_82840_a((EntityPlayer)MCClientHelper.getPlayer(), false));
        }
    }

    @Override
    public String getPurchaseableID() {
        return this.resource;
    }
}

