/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.packet;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.PenguinPacket;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.player.stats.StatsServer;
import joshie.harvest.shops.Shop;
import joshie.harvest.shops.ShopRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Packet
public class PacketPurchaseItem
extends PenguinPacket {
    private IPurchasable purchasable;
    private Shop shop;

    public PacketPurchaseItem() {
    }

    public PacketPurchaseItem(Shop shop, IPurchasable purchasable) {
        this.shop = shop;
        this.purchasable = purchasable;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.shop.resourceLocation.toString());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.purchasable.getPurchaseableID());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.shop = ShopRegistry.INSTANCE.getShop(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        this.purchasable = this.shop.getPurchasableFromID(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            if (this.purchasable.canBuy(player.field_70170_p, player) && this.purchase((EntityPlayerMP)player, this.shop, this.purchasable, this.purchasable.getCost())) {
                player.func_71053_j();
            }
        } else {
            this.purchasable.onPurchased(player);
        }
    }

    private boolean purchase(EntityPlayerMP player, Shop shop, IPurchasable purchaseable, long cost) {
        StatsServer stats = ((PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer((EntityPlayer)player)).getStats();
        if (stats.getGold() - cost >= 0L) {
            stats.addGold(player, -cost);
            PacketHandler.sendToClient(new PacketPurchaseItem(shop, purchaseable), (EntityPlayer)player);
            return purchaseable.onPurchased((EntityPlayer)player);
        }
        return false;
    }
}

