/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.gui;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.api.shops.IShopGuiOverlay;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.StackHelper;
import joshie.harvest.core.lib.HFModInfo;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.ShopFontRenderer;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.gui.GuiNPCBase;
import joshie.harvest.player.stats.StatsClient;
import joshie.harvest.shops.Shop;
import joshie.harvest.shops.packet.PacketPurchaseItem;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;

public class GuiNPCShop
extends GuiNPCBase {
    protected static final ResourceLocation gui_texture = new ResourceLocation("harvestfestival", "textures/gui/shop.png");
    protected static final ResourceLocation shelve_texture = new ResourceLocation("harvestfestival", "textures/gui/shop_extra.png");
    protected final StatsClient stats;
    protected final List<IPurchasable> contents;
    protected final IShopGuiOverlay overlay;
    protected final Shop shop;
    protected int start;
    private static final DecimalFormat formatter = new DecimalFormat("#,###");

    public GuiNPCShop(EntityPlayer player, EntityNPC npc, int nextGui) {
        super(player, npc, EnumHand.MAIN_HAND, nextGui);
        this.shop = npc.getNPC().getShop();
        if (this.shop == null || !this.shop.isOpen(player.field_70170_p, player)) {
            player.func_71053_j();
        }
        this.overlay = this.shop.getGuiOverlay();
        this.contents = this.shop.getContents(player);
        this.stats = HFTrackers.getClientPlayerTracker().getStats();
    }

    public void setStart(int i) {
        this.start = Math.max(0, Math.min(this.contents.size() - this.getMax(), i));
    }

    @Override
    public void drawBackground(int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        this.field_146297_k.field_71446_o.func_110577_a(gui_texture);
        this.func_73729_b(x, y += 20, 0, 0, this.xSize, this.ySize);
        if (this.overlay != null) {
            this.overlay.renderOverlay(this, x, y, this.xSize, this.ySize);
        }
        ShopFontRenderer.render(this, x + 20, y + 16, this.shop.getLocalizedName(), false);
        this.drawCoinage(x, y, this.stats.getGold());
        this.drawShelves(x, y);
        this.field_146297_k.field_71446_o.func_110577_a(shelve_texture);
        int up = 0;
        int down = 0;
        if (this.mouseX >= 231 && this.mouseX <= 242) {
            up = this.mouseY >= 66 && this.mouseY <= 75 ? 17 : 0;
            int n = down = this.mouseY >= 231 && this.mouseY <= 240 ? 17 : 0;
        }
        if (this.start != 0) {
            this.func_73729_b(x + 230, y + 45, 72 + up, 34, 14, 11);
        }
        if (this.start < this.contents.size() - this.getMax()) {
            this.func_73729_b(x + 230, y + 210, 72 + down, 47, 14, 11);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    protected String getCostAsString(long cost) {
        if (cost < 1000L) {
            return "" + cost;
        }
        long remainder = cost % 1000L;
        int decimal = remainder == 0L ? 0 : (remainder % 100L == 0L ? 1 : (remainder % 10L == 0L ? 2 : 3));
        int exp = (int)(Math.log(cost) / Math.log(1000.0));
        return String.format("%." + decimal + "f%c", (double)cost / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    protected void drawShelves(int x, int y) {
        int index = 0;
        for (int i = this.start; i < this.contents.size() && index <= this.getMax(); ++index, ++i) {
            IPurchasable purchaseable = this.contents.get(i);
            ItemStack display = purchaseable.getDisplayStack();
            long cost = purchaseable.getCost();
            this.field_146297_k.field_71446_o.func_110577_a(shelve_texture);
            int indexPercent = index % 2;
            int indexDivide = index / 2;
            int percent99 = indexPercent * 99;
            int percent37 = indexDivide * 37;
            int x99 = percent99 + x;
            int y37 = y + percent37;
            this.func_73729_b(x + 29 + indexPercent * 101, y37 + 41, 0, 0, 160, 32);
            int xOffset = 0;
            int posY = 41 + percent37;
            int posX = 98 + percent99;
            if (this.mouseY >= posY + 23 && this.mouseY <= posY + 46 && this.mouseX >= posX - 63 && this.mouseX <= posX - 41) {
                ArrayList<String> list = new ArrayList<String>();
                purchaseable.addTooltip(list);
                this.addTooltip(list);
            }
            if (this.mouseY >= posY + 20 && this.mouseY <= posY + 52 && this.mouseX >= posX && this.mouseX <= posX + 28) {
                xOffset = 32;
            }
            this.func_73729_b(x + posX, y + posY, xOffset, 32, 32, 32);
            GlStateManager.func_179147_l();
            this.field_146297_k.field_71446_o.func_110577_a(HFModInfo.ELEMENTS);
            this.func_73729_b(x99 + 59, y37 + 50, 244, 0, 12, 12);
            this.field_146297_k.field_71466_p.func_175063_a(this.getCostAsString(cost), (float)(x99 + 73), (float)(y37 + 53), 0xFFFFFF);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            StackHelper.drawStack(display, x99 + 36, y37 + 46, 1.4f);
        }
    }

    private void drawCoinage(int x, int y, long gold) {
        String formatted = String.valueOf(formatter.format(gold));
        ShopFontRenderer.render(this, x + 210, y + 16, formatted, true);
        GlStateManager.func_179097_i();
        this.field_146297_k.field_71446_o.func_110577_a(HFModInfo.ELEMENTS);
        this.field_146297_k.field_71456_v.func_73729_b(x + 230 - 15, y + 15, 244, 0, 12, 12);
        GlStateManager.func_179126_j();
    }

    @Override
    public void drawForeground(int x, int y) {
    }

    @Override
    public void drawOverlay(int x, int y) {
    }

    @Override
    protected void func_73869_a(char character, int key) throws IOException {
        if (key == 208 || character == 's') {
            this.setStart(this.start + 2);
        }
        if (key == 200 || character == 'w') {
            this.setStart(this.start - 2);
        }
        super.func_73869_a(character, key);
    }

    @Override
    protected void onMouseClick(int x, int y) {
        int index = 0;
        for (int i = this.start; i < this.contents.size() && index <= this.getMax(); ++i) {
            IPurchasable purchaseable = this.contents.get(i);
            if (!purchaseable.canBuy(this.player.field_70170_p, this.player)) continue;
            int indexPercent = index % 2;
            int indexDivide = index / 2;
            int percent99 = indexPercent * 99;
            int percent37 = indexDivide * 37;
            int posY = 41 + percent37;
            int posX = 98 + percent99;
            if (this.stats.getGold() - purchaseable.getCost() >= 0L && this.mouseY >= posY + 20 && this.mouseY <= posY + 52 && this.mouseX >= posX && this.mouseX <= posX + 32) {
                for (int j = 0; j < (GuiScreen.func_146272_n() ? 64 : 1); ++j) {
                    PacketHandler.sendToServer(new PacketPurchaseItem(this.shop, purchaseable));
                }
            }
            ++index;
        }
        boolean up = false;
        boolean down = false;
        if (this.mouseX >= 231 && this.mouseX <= 242) {
            up = this.mouseY >= 66 && this.mouseY <= 75;
            boolean bl = down = this.mouseY >= 231 && this.mouseY <= 240;
        }
        if (down && this.start < this.contents.size() - this.getMax()) {
            this.setStart(this.start + this.getIncrease());
        } else if (up && this.start != 0) {
            this.setStart(this.start - this.getIncrease());
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.mouseWheel != 0) {
            if (this.mouseWheel < 0) {
                this.setStart(this.start + this.getIncrease());
            } else {
                this.setStart(this.start - this.getIncrease());
            }
        }
    }

    public int getIncrease() {
        return 2;
    }

    public int getMax() {
        return 9;
    }
}

