/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.data;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.core.helpers.CollectionHelper;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.util.interfaces.INBTSerializableMap;
import joshie.harvest.player.tracking.StackSold;
import joshie.harvest.shops.Shop;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ShopInventory
implements INBTSerializableMap<Shop, ShopInventory, NBTTagCompound> {
    private Set<StackSold> soldToShop = new HashSet<StackSold>();
    private Set<StackSold> purchasedFromShop = new HashSet<StackSold>();
    private Shop shop;

    public ShopInventory() {
    }

    public ShopInventory(Shop shop) {
        this.shop = shop;
    }

    public void onItemSoldToShop(IPurchasable purchasable) {
        StackSold stack = StackSold.of(purchasable.getDisplayStack(), purchasable.getCost());
        CollectionHelper.mergeCollection(stack, this.soldToShop);
    }

    public StackSold onItemPurchasedFromShop(IPurchasable purchasable) {
        StackSold stack = StackSold.of(purchasable.getDisplayStack(), purchasable.getCost());
        return CollectionHelper.mergeCollection(stack, this.purchasedFromShop);
    }

    public long getAdjustedSellToShopValue(IPurchasable purchasable) {
        return Math.min(0L, (long)((double)purchasable.getCost() * (1.0 - (double)this.getAmountPurchased(purchasable) / (double)purchasable.getStock())));
    }

    public boolean canList(IPurchasable purchasable) {
        return purchasable.getCost() < 0L ? this.getAdjustedSellToShopValue(purchasable) < 0L : this.getAmountPurchased(purchasable) < purchasable.getStock();
    }

    private int getAmountPurchased(IPurchasable purchasable) {
        StackSold comparable = StackSold.of(purchasable.getDisplayStack(), purchasable.getCost());
        for (StackSold sold : purchasable.getCost() < 0L ? this.soldToShop : this.purchasedFromShop) {
            if (!sold.equals(comparable)) continue;
            return sold.getAmount();
        }
        return 0;
    }

    public void newDay() {
        this.purchasedFromShop.stream().forEach((Consumer<StackSold>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, reset(), (Ljoshie/harvest/player/tracking/StackSold;)V)());
        this.soldToShop.stream().forEach((Consumer<StackSold>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, depreciate(), (Ljoshie/harvest/player/tracking/StackSold;)V)());
    }

    @Override
    public void buildMap(Map<Shop, ShopInventory> map) {
        map.put(this.shop, this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.shop = (Shop)HFApi.shops.getShop(new ResourceLocation(nbt.func_74779_i("Shop")));
        this.soldToShop = NBTHelper.readHashSet(StackSold.class, nbt.func_150295_c("Purchased", 10));
        this.purchasedFromShop = NBTHelper.readHashSet(StackSold.class, nbt.func_150295_c("Sold", 10));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Shop", this.shop.resourceLocation.toString());
        tag.func_74782_a("Purchased", (NBTBase)NBTHelper.writeCollection(this.soldToShop));
        tag.func_74782_a("Sold", (NBTBase)NBTHelper.writeCollection(this.purchasedFromShop));
        return tag;
    }
}

