/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops.data;

import java.util.HashMap;
import java.util.UUID;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.shops.Shop;
import joshie.harvest.shops.data.ShopInventory;
import joshie.harvest.shops.packet.PacketSyncSold;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ShopData {
    private HashMap<Shop, ShopInventory> data = new HashMap();

    public void onPurchasableHandled(EntityPlayer player, Shop shop, IPurchasable purchasable) {
        this.data.putIfAbsent(shop, new ShopInventory(shop));
        if (purchasable.getCost() < 0L) {
            this.data.get(shop).onItemSoldToShop(purchasable);
        } else {
            this.data.get(shop).onItemPurchasedFromShop(purchasable);
        }
        purchasable.onPurchased(player);
    }

    public boolean canList(Shop shop, IPurchasable purchasable) {
        this.data.putIfAbsent(shop, new ShopInventory(shop));
        return this.data.get(shop).canList(purchasable);
    }

    public long getSellValue(Shop shop, IPurchasable purchasable) {
        if (purchasable.getCost() >= 0L) {
            return purchasable.getCost();
        }
        this.data.putIfAbsent(shop, new ShopInventory(shop));
        return this.data.get(shop).getAdjustedSellToShopValue(purchasable);
    }

    public void newDay(World world, UUID uuid) {
        this.data.values().stream().forEach(ShopInventory::newDay);
        PacketHandler.sendToDimension(world.field_73011_w.getDimension(), (IMessage)new PacketSyncSold(uuid, this.writeToNBT(new NBTTagCompound())));
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTHelper.readMap((String)"Shops", ShopInventory.class, this.data, (NBTTagCompound)nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTHelper.writeMap((String)"Shops", (NBTTagCompound)nbt, this.data);
        return nbt;
    }
}

