/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Weekday;
import joshie.harvest.api.shops.IPurchasable;
import joshie.harvest.api.shops.IShop;
import joshie.harvest.api.shops.IShopGuiOverlay;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.core.util.Text;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.shops.HFShops;
import joshie.harvest.shops.purchasable.Purchasable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Shop
implements IShop {
    private final LinkedHashMap<String, IPurchasable> contents = new LinkedHashMap();
    private final HashMultimap<Weekday, OpeningHours> open = HashMultimap.create();
    public final ResourceLocation resourceLocation;
    public final String unlocalizedName;
    @SideOnly(value=Side.CLIENT)
    private IShopGuiOverlay overlay;

    public Shop(ResourceLocation resource) {
        this.resourceLocation = resource;
        this.unlocalizedName = resource.func_110624_b() + ".shop." + resource.func_110623_a();
    }

    @Override
    public IShop addOpening(Weekday day, int opening, int closing) {
        this.open.get((Object)day).add(new OpeningHours(opening, closing));
        return this;
    }

    public IPurchasable getPurchasableFromID(String string) {
        return this.contents.get(string);
    }

    public IPurchasable removeItem(ItemStack stack) {
        for (IPurchasable check : this.contents.values()) {
            if (check.getDisplayStack() == null || !check.getDisplayStack().func_77969_a(stack)) continue;
            return check;
        }
        return null;
    }

    public IPurchasable removeItem(String id) {
        for (IPurchasable check : this.contents.values()) {
            if (check.getPurchaseableID() == null || !check.getPurchaseableID().equals(id)) continue;
            return check;
        }
        return null;
    }

    public void removeItem(IPurchasable item) {
        if (item != null) {
            this.contents.remove(item.getPurchaseableID());
        }
    }

    public Set<String> getIDs() {
        return this.contents.keySet();
    }

    @Override
    public IShop addItem(IPurchasable item) {
        if (item != null) {
            this.contents.put(item.getPurchaseableID(), item);
        }
        return this;
    }

    public static ResourceLocation getRegistryName(ResourceLocation resource, IPurchasable item) {
        return new ResourceLocation(Loader.instance().activeModContainer().getModId().toLowerCase(Locale.ENGLISH) + ":" + resource.func_110623_a() + "_" + item.getPurchaseableID());
    }

    @Override
    public IShop addItem(long cost, ItemStack ... items) {
        return this.addItem(new Purchasable(cost, items));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IShop setGuiOverlay(IShopGuiOverlay overlay) {
        this.overlay = overlay;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public IShopGuiOverlay getGuiOverlay() {
        return this.overlay;
    }

    public String getLocalizedName() {
        return Text.localize(this.unlocalizedName);
    }

    public String getWelcome(EntityPlayer player, EntityNPC npc) {
        return Text.getRandomSpeech(npc.getNPC(), this.unlocalizedName + ".greeting", 100, new Object[0]);
    }

    public List<IPurchasable> getContents(@Nonnull EntityPlayer player) {
        ArrayList<IPurchasable> contents = new ArrayList<IPurchasable>();
        for (IPurchasable purchaseable : this.contents.values()) {
            if (!purchaseable.canList(player.field_70170_p, player)) continue;
            contents.add(purchaseable);
        }
        return contents;
    }

    public boolean isOpen(World world, @Nullable EntityPlayer player) {
        if (HFShops.TWENTY_FOUR_HOUR_SHOPPING) {
            return true;
        }
        Weekday day = HFApi.calendar.getDate(world).getWeekday();
        for (OpeningHours hours : this.open.get((Object)day)) {
            long daytime = CalendarHelper.getTime(world);
            int scaledOpening = CalendarHelper.getScaledTime(hours.open);
            int scaledClosing = CalendarHelper.getScaledTime(hours.close);
            boolean isOpen = daytime >= (long)scaledOpening && daytime <= (long)scaledClosing;
            if (!isOpen || player != null && this.getContents(player).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isPreparingToOpen(World world) {
        if (HFShops.TWENTY_FOUR_HOUR_SHOPPING) {
            return false;
        }
        Weekday day = HFApi.calendar.getDate(world).getWeekday();
        for (OpeningHours hours : this.open.get((Object)day)) {
            int hourHalfBeforeWork;
            long daytime = CalendarHelper.getTime(world);
            if (daytime < (long)(hourHalfBeforeWork = this.fix(CalendarHelper.getScaledTime(hours.open) - 1500))) continue;
            return true;
        }
        return false;
    }

    private int fix(int i) {
        return Math.min(24000, Math.max(0, i));
    }

    private static class OpeningHours {
        private final int open;
        private final int close;

        OpeningHours(int open, int close) {
            this.open = open;
            this.close = close;
        }
    }
}

