/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.shops;

import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.block.BlockSizedStorage;
import joshie.harvest.animals.block.BlockTray;
import joshie.harvest.animals.block.BlockTrough;
import joshie.harvest.animals.entity.EntityHarvestChicken;
import joshie.harvest.animals.entity.EntityHarvestCow;
import joshie.harvest.animals.entity.EntityHarvestSheep;
import joshie.harvest.animals.item.ItemAnimalSpawner;
import joshie.harvest.animals.item.ItemAnimalTool;
import joshie.harvest.animals.item.ItemAnimalTreat;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weekday;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.api.shops.IShop;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.cooking.block.BlockCookware;
import joshie.harvest.cooking.item.ItemIngredients;
import joshie.harvest.cooking.item.ItemUtensil;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.block.BlockStorage;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.util.HFLoader;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.crops.block.BlockSprinkler;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.block.BlockLadder;
import joshie.harvest.mining.block.BlockStone;
import joshie.harvest.mining.item.ItemMiningTool;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.item.ItemNPCTool;
import joshie.harvest.shops.purchasable.PurchasableBlueFeather;
import joshie.harvest.shops.purchasable.PurchasableBuilder;
import joshie.harvest.shops.purchasable.PurchasableBuilding;
import joshie.harvest.shops.purchasable.PurchasableCropSeeds;
import joshie.harvest.shops.purchasable.PurchasableDecorative;
import joshie.harvest.shops.purchasable.PurchasableEntity;
import joshie.harvest.shops.purchasable.PurchasableMeal;
import joshie.harvest.shops.purchasable.PurchasableRecipe;
import joshie.harvest.shops.purchasable.PurchasableWeekend;
import joshie.harvest.shops.purchasable.PurchasableYearWeekend;
import joshie.harvest.tools.HFTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@HFLoader
public class HFShops {
    public static IShop BARN;
    public static IShop BLACKSMITH;
    public static IShop CAFE;
    public static IShop CARPENTER;
    public static IShop POULTRY;
    public static IShop SUPERMARKET;
    public static IShop MINER;
    public static boolean TWENTY_FOUR_HOUR_SHOPPING;

    public static void postInit() {
        HFShops.registerBarn();
        HFShops.registerBlacksmith();
        HFShops.registerCafe();
        HFShops.registerCarpenter();
        HFShops.registerPoultry();
        HFShops.registerSupermarket();
        HFShops.registerMiner();
    }

    private static void registerBarn() {
        BARN = HFApi.shops.newShop(new ResourceLocation("harvestfestival", "barn"), HFNPCs.ANIMAL_OWNER);
        BARN.addItem(10L, HFAnimals.TREATS.getStackFromEnum(ItemAnimalTreat.Treat.GENERIC));
        BARN.addItem(30L, HFAnimals.TREATS.getStackFromEnum(ItemAnimalTreat.Treat.COW));
        BARN.addItem(30L, HFAnimals.TREATS.getStackFromEnum(ItemAnimalTreat.Treat.SHEEP));
        BARN.addItem(20L, HFCrops.GRASS.getCropStack(1));
        BARN.addItem(1000L, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.MEDICINE));
        BARN.addItem(new PurchasableEntity(EntityHarvestSheep.class, 4000L, HFAnimals.ANIMAL.getStackFromEnum(ItemAnimalSpawner.Spawner.SHEEP), true));
        BARN.addItem(new PurchasableEntity(EntityHarvestCow.class, 5000L, HFAnimals.ANIMAL.getStackFromEnum(ItemAnimalSpawner.Spawner.COW), true));
        BARN.addItem(3000L, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.MIRACLE_POTION));
        BARN.addItem(500L, HFAnimals.TROUGH.getStackFromEnum(BlockTrough.Trough.WOOD));
        BARN.addItem(250L, new ItemStack(Items.field_151057_cb));
        BARN.addOpening(Weekday.MONDAY, 10000, 15000).addOpening(Weekday.TUESDAY, 10000, 15000).addOpening(Weekday.WEDNESDAY, 10000, 15000);
        BARN.addOpening(Weekday.THURSDAY, 10000, 15000).addOpening(Weekday.FRIDAY, 10000, 15000).addOpening(Weekday.SATURDAY, 10000, 15000);
    }

    private static void registerBlacksmith() {
        BLACKSMITH = HFApi.shops.newShop(new ResourceLocation("harvestfestival", "blacksmith"), HFNPCs.TOOL_OWNER);
        BLACKSMITH.addItem(800L, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.BRUSH));
        BLACKSMITH.addItem(2000L, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.MILKER));
        BLACKSMITH.addItem(1800L, new ItemStack((Item)Items.field_151097_aZ));
        BLACKSMITH.addItem(250L, HFTools.HOE.getStack(ITiered.ToolTier.BASIC));
        BLACKSMITH.addItem(250L, HFTools.SICKLE.getStack(ITiered.ToolTier.BASIC));
        BLACKSMITH.addItem(500L, HFTools.WATERING_CAN.getStack(ITiered.ToolTier.BASIC));
        BLACKSMITH.addItem(1000L, HFTools.AXE.getStack(ITiered.ToolTier.BASIC));
        BLACKSMITH.addItem(1000L, HFTools.HAMMER.getStack(ITiered.ToolTier.BASIC));
        BLACKSMITH.addItem(new PurchasableWeekend(100L, HFCore.STORAGE.getStackFromEnum(BlockStorage.Storage.SHIPPING), new ItemStack[0]));
        BLACKSMITH.addItem(new PurchasableYearWeekend(10000L, HFCrops.SPRINKLER.getStackFromEnum(BlockSprinkler.Sprinkler.WOOD), 1));
        BLACKSMITH.addOpening(Weekday.SUNDAY, 10000, 16000).addOpening(Weekday.MONDAY, 10000, 16000).addOpening(Weekday.TUESDAY, 10000, 16000);
        BLACKSMITH.addOpening(Weekday.WEDNESDAY, 10000, 16000).addOpening(Weekday.FRIDAY, 10000, 16000).addOpening(Weekday.SATURDAY, 10000, 16000);
    }

    private static void registerCafe() {
        CAFE = HFApi.shops.newShop(new ResourceLocation("harvestfestival", "cafe"), HFNPCs.CAFE_OWNER);
        CAFE.addItem(0L, new ItemStack((Item)Items.field_151068_bn));
        CAFE.addItem(new PurchasableMeal(500L, new ResourceLocation("harvestfestival", "salad")));
        CAFE.addItem(new PurchasableMeal(400L, new ResourceLocation("harvestfestival", "cookies")));
        CAFE.addItem(new PurchasableMeal(750L, new ResourceLocation("harvestfestival", "juice_pineapple")));
        CAFE.addItem(new PurchasableMeal(250L, new ResourceLocation("harvestfestival", "corn_baked")));
        CAFE.addItem(new PurchasableWeekend(25L, new ItemStack((Item)HFCooking.COOKBOOK), new ItemStack[0]));
        CAFE.addItem(new PurchasableWeekend(50L, HFCooking.UTENSILS.getStackFromEnum(ItemUtensil.Utensil.KNIFE), new ItemStack[0]));
        CAFE.addItem(new PurchasableWeekend(250L, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.COUNTER), new ItemStack[0]));
        CAFE.addItem(new PurchasableWeekend(3000L, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.FRIDGE), new ItemStack[0]));
        CAFE.addItem(new PurchasableWeekend(2500L, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.OVEN_OFF), new ItemStack[0]));
        CAFE.addItem(new PurchasableWeekend(1500L, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.FRYING_PAN), new ItemStack[]{HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.OVEN_OFF)}));
        CAFE.addItem(new PurchasableWeekend(1000L, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.POT), new ItemStack[]{HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.OVEN_OFF)}));
        CAFE.addItem(new PurchasableWeekend(1200L, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.MIXER), new ItemStack[]{HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.COUNTER)}));
        CAFE.addItem(new PurchasableRecipe(Season.SPRING, Weekday.MONDAY, new ResourceLocation("harvestfestival", "juice_vegetable")));
        CAFE.addItem(new PurchasableRecipe(Season.SPRING, Weekday.TUESDAY, new ResourceLocation("harvestfestival", "sushi")));
        CAFE.addItem(new PurchasableRecipe(Season.SPRING, Weekday.WEDNESDAY, new ResourceLocation("harvestfestival", "sashimi")));
        CAFE.addItem(new PurchasableRecipe(Season.SPRING, Weekday.THURSDAY, new ResourceLocation("harvestfestival", "sashimi_chirashi")));
        CAFE.addItem(new PurchasableRecipe(Season.SPRING, Weekday.FRIDAY, new ResourceLocation("harvestfestival", "cucumber_pickled")));
        CAFE.addItem(new PurchasableRecipe(Season.SUMMER, Weekday.SATURDAY, new ResourceLocation("harvestfestival", "juice_tomato")));
        CAFE.addItem(new PurchasableRecipe(Season.SUMMER, Weekday.SUNDAY, new ResourceLocation("harvestfestival", "cornflakes")));
        CAFE.addItem(new PurchasableRecipe(Season.SUMMER, Weekday.MONDAY, new ResourceLocation("harvestfestival", "ketchup")));
        CAFE.addItem(new PurchasableRecipe(Season.SUMMER, Weekday.TUESDAY, new ResourceLocation("harvestfestival", "stew_pumpkin")));
        CAFE.addItem(new PurchasableRecipe(Season.SUMMER, Weekday.THURSDAY, new ResourceLocation("harvestfestival", "doria")));
        CAFE.addItem(new PurchasableRecipe(Season.AUTUMN, Weekday.TUESDAY, new ResourceLocation("harvestfestival", "eggplant_happy")));
        CAFE.addItem(new PurchasableRecipe(Season.AUTUMN, Weekday.WEDNESDAY, new ResourceLocation("harvestfestival", "sandwich")));
        CAFE.addItem(new PurchasableRecipe(Season.AUTUMN, Weekday.SATURDAY, new ResourceLocation("harvestfestival", "spinach_boiled")));
        CAFE.addItem(new PurchasableRecipe(Season.AUTUMN, Weekday.SUNDAY, new ResourceLocation("harvestfestival", "riceballs_toasted")));
        CAFE.addItem(new PurchasableRecipe(Season.WINTER, Weekday.MONDAY, new ResourceLocation("harvestfestival", "omelet")));
        CAFE.addItem(new PurchasableRecipe(Season.WINTER, Weekday.TUESDAY, new ResourceLocation("harvestfestival", "egg_boiled")));
        CAFE.addItem(new PurchasableRecipe(Season.WINTER, Weekday.WEDNESDAY, new ResourceLocation("harvestfestival", "egg_overrice")));
        CAFE.addItem(new PurchasableRecipe(Season.WINTER, Weekday.FRIDAY, new ResourceLocation("harvestfestival", "pancake")));
        CAFE.addOpening(Weekday.MONDAY, 9500, 17000).addOpening(Weekday.TUESDAY, 9500, 17000).addOpening(Weekday.WEDNESDAY, 9500, 17000).addOpening(Weekday.THURSDAY, 9500, 17000);
        CAFE.addOpening(Weekday.FRIDAY, 9500, 17000).addOpening(Weekday.SATURDAY, 9500, 17000).addOpening(Weekday.SUNDAY, 9500, 17000);
    }

    private static void registerCarpenter() {
        CARPENTER = HFApi.shops.newShop(new ResourceLocation("harvestfestival", "carpenter"), HFNPCs.BUILDER);
        for (BuildingImpl building : BuildingRegistry.REGISTRY.getValues()) {
            if (!building.canPurchase()) continue;
            CARPENTER.addItem(new PurchasableBuilding(building));
        }
        CARPENTER.addItem(new PurchasableBuilder(0L, 16, 0, HFCore.STORAGE.getStackFromEnum(BlockStorage.Storage.SHIPPING)));
        CARPENTER.addItem(new PurchasableBuilder(100L, 0, 0, new ItemStack(Blocks.field_150364_r)));
        CARPENTER.addItem(new PurchasableBuilder(50L, 0, 0, new ItemStack(Blocks.field_150348_b)));
        if (!HFAnimals.CAN_SPAWN) {
            CARPENTER.addItem(new PurchasableBuilder(500L, 3, 0, new ItemStack(Items.field_151104_aV)));
        }
        CARPENTER.addOpening(Weekday.MONDAY, 9000, 17500).addOpening(Weekday.TUESDAY, 9000, 17500).addOpening(Weekday.WEDNESDAY, 9000, 17500);
        CARPENTER.addOpening(Weekday.THURSDAY, 9000, 17500).addOpening(Weekday.FRIDAY, 9000, 17500).addOpening(Weekday.SUNDAY, 9000, 17500);
    }

    private static void registerPoultry() {
        POULTRY = HFApi.shops.newShop(new ResourceLocation("harvestfestival", "poultry"), HFNPCs.POULTRY);
        POULTRY.addItem(new PurchasableEntity(EntityHarvestChicken.class, 1500L, HFAnimals.ANIMAL.getStackFromEnum(ItemAnimalSpawner.Spawner.CHICKEN), false));
        POULTRY.addItem(1000L, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.MEDICINE));
        POULTRY.addItem(10L, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.CHICKEN_FEED));
        POULTRY.addItem(10L, HFAnimals.TREATS.getStackFromEnum(ItemAnimalTreat.Treat.GENERIC));
        POULTRY.addItem(30L, HFAnimals.TREATS.getStackFromEnum(ItemAnimalTreat.Treat.CHICKEN));
        POULTRY.addItem(500L, HFAnimals.TRAY.getStackFromEnum(BlockTray.Tray.FEEDER_EMPTY));
        POULTRY.addItem(1000L, HFAnimals.TRAY.getStackFromEnum(BlockTray.Tray.NEST_EMPTY));
        POULTRY.addItem(7500L, HFAnimals.SIZED.getStackFromEnum(BlockSizedStorage.SizedStorage.INCUBATOR));
        POULTRY.addItem(250L, new ItemStack(Items.field_151057_cb));
        POULTRY.addOpening(Weekday.MONDAY, 5000, 11000).addOpening(Weekday.TUESDAY, 5000, 11000).addOpening(Weekday.WEDNESDAY, 5000, 11000);
        POULTRY.addOpening(Weekday.THURSDAY, 5000, 11000).addOpening(Weekday.FRIDAY, 5000, 11000).addOpening(Weekday.SATURDAY, 5000, 11000);
    }

    private static void registerSupermarket() {
        SUPERMARKET = HFApi.shops.newShop(new ResourceLocation("harvestfestival", "general"), HFNPCs.GS_OWNER);
        for (Crop crop : Crop.REGISTRY.getValues()) {
            if (crop == Crop.NULL_CROP) continue;
            SUPERMARKET.addItem(new PurchasableCropSeeds(crop));
        }
        SUPERMARKET.addItem(100L, new ItemStack(Items.field_151025_P));
        SUPERMARKET.addItem(50L, HFCooking.INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.FLOUR));
        SUPERMARKET.addItem(100L, HFCooking.INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.CHOCOLATE));
        SUPERMARKET.addItem(50L, HFCooking.INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.OIL));
        SUPERMARKET.addItem(100L, HFCooking.INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.RICEBALL));
        SUPERMARKET.addItem(25L, HFCooking.INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.SALT));
        SUPERMARKET.addItem(new PurchasableBlueFeather(1000, HFNPCs.TOOLS.getStackFromEnum(ItemNPCTool.NPCTool.BLUE_FEATHER)));
        SUPERMARKET.addOpening(Weekday.MONDAY, 9000, 17000).addOpening(Weekday.TUESDAY, 9000, 17000).addOpening(Weekday.THURSDAY, 9000, 17000);
        SUPERMARKET.addOpening(Weekday.FRIDAY, 9000, 17000).addOpening(Weekday.SATURDAY, 11000, 15000);
    }

    private static void registerMiner() {
        MINER = HFApi.shops.newShop(new ResourceLocation("harvestfestival", "miner"), HFNPCs.MINER);
        MINER.addItem(new PurchasableDecorative(1000, new ItemStack((Block)HFMining.DIRT_DECORATIVE, 16, 0)));
        MINER.addItem(new PurchasableDecorative(500, HFMining.LADDER.getStackFromEnum(BlockLadder.Ladder.DECORATIVE)));
        MINER.addItem(150L, HFMining.MINING_TOOL.getStackFromEnum(ItemMiningTool.MiningTool.ESCAPE_ROPE));
        for (BlockStone.Type type : BlockStone.Type.values()) {
            if (!type.isFake()) continue;
            MINER.addItem(new PurchasableDecorative(1000, new ItemStack((Block)HFMining.STONE, 16, type.ordinal())));
        }
        MINER.addOpening(Weekday.MONDAY, 11000, 16000).addOpening(Weekday.TUESDAY, 11000, 16000).addOpening(Weekday.WEDNESDAY, 11000, 16000);
        MINER.addOpening(Weekday.THURSDAY, 11000, 16000).addOpening(Weekday.FRIDAY, 11000, 16000).addOpening(Weekday.SATURDAY, 11000, 16000);
    }

    public static void configure() {
        TWENTY_FOUR_HOUR_SHOPPING = ConfigHelper.getBoolean("Shops are open all the time", false);
    }
}

