/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import java.util.Set;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.Quests;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

@HFQuest(value="tutorial.supermarket")
public class QuestSupermarket
extends Quest {
    private static final int START = 0;

    public QuestSupermarket() {
        this.setNPCs(HFNPCs.SEED_OWNER, HFNPCs.GS_OWNER, HFNPCs.MILKMAID);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_CROPS);
    }

    @Override
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.quest_stage == 0 && npc == HFNPCs.SEED_OWNER) {
            if (player.field_70170_p.field_73012_v.nextFloat() < 0.15f) {
                if (((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)entity)).hasBuilding(HFBuildings.SUPERMARKET)) {
                    return this.getLocalized("reminder.talk", new Object[0]);
                }
                return this.getLocalized("reminder.supermarket", new Object[0]);
            }
            return null;
        }
        if (this.quest_stage == 0 && (npc == HFNPCs.GS_OWNER || npc == HFNPCs.MILKMAID)) {
            return npc == HFNPCs.GS_OWNER ? this.getLocalized("welcome.owner", new Object[0]) : this.getLocalized("welcome.guest", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.quest_stage == 0 && npc != HFNPCs.SEED_OWNER) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        Season season = HFApi.calendar.getSeasonAtCoordinates(player.field_70170_p, new BlockPos((Entity)player));
        if (season == Season.SUMMER) {
            this.rewardItem(player, HFCrops.TOMATO.getSeedStack(4));
        } else if (season == Season.AUTUMN) {
            this.rewardItem(player, HFCrops.EGGPLANT.getSeedStack(4));
        } else {
            this.rewardItem(player, HFCrops.CUCUMBER.getSeedStack(4));
        }
    }
}

