/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import java.util.Set;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.Quests;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

@HFQuest(value="tutorial.pond")
public class QuestPond
extends Quest {
    public QuestPond() {
        this.setNPCs(HFNPCs.GODDESS);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_UPGRADING);
    }

    @Override
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)entity)).hasBuilding(HFBuildings.GODDESS_POND)) {
            return player.field_70170_p.field_73012_v.nextDouble() <= 0.1 ? this.getLocalized("thanks", new Object[0]) : null;
        }
        return this.getLocalized("please", new Object[0]);
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)entity)).hasBuilding(HFBuildings.GODDESS_POND)) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, HFCrops.STRAWBERRY.getCropStack(64));
        this.rewardGold(player, 5000L);
    }
}

