/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import java.util.Set;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.api.quests.QuestQuestion;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.item.ItemMaterial;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.TutorialSelection;
import joshie.harvest.tools.HFTools;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@HFQuest(value="tutorial.upgrading")
public class QuestMining
extends QuestQuestion {
    private static final int BUILD = 0;
    private static final int EXPLAIN = 1;
    private static final int FINISH = 2;

    public QuestMining() {
        super(new TutorialSelection("upgrading"));
        this.setNPCs(HFNPCs.BUILDER, HFNPCs.GODDESS, HFNPCs.ANIMAL_OWNER, HFNPCs.GS_OWNER, HFNPCs.SEED_OWNER, HFNPCs.MILKMAID, HFNPCs.TOOL_OWNER, HFNPCs.MINER);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_COW) && finished.contains((Object)Quests.TUTORIAL_CHICKEN) && finished.contains((Object)Quests.TUTORIAL_SUPERMARKET);
    }

    @Override
    public Quest.Selection getSelection(EntityPlayer player, INPC npc) {
        return npc == HFNPCs.TOOL_OWNER ? super.getSelection(player, npc) : null;
    }

    @Override
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.quest_stage == 0 && npc != HFNPCs.TOOL_OWNER && player.field_70170_p.field_73012_v.nextFloat() < 0.25f) {
            String suffix = ((NPC)npc).getRegistryName().func_110623_a();
            boolean blacksmith = ((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)entity)).hasBuilding(HFBuildings.BLACKSMITH);
            if (blacksmith) {
                return this.getLocalized("reminder.blacksmith." + suffix, new Object[0]);
            }
            return this.getLocalized("blacksmith." + suffix, new Object[0]);
        }
        if (npc == HFNPCs.TOOL_OWNER) {
            if (this.isCompletedEarly) {
                return this.getLocalized("completed", new Object[0]);
            }
            if (this.quest_stage == 0) {
                return this.getLocalized("intro", new Object[0]);
            }
            if (this.quest_stage == 1) {
                return this.getLocalized("explain", new Object[0]);
            }
            if (this.quest_stage == 2) {
                return this.getLocalized("reminder.visit", new Object[0]);
            }
        } else if (npc == HFNPCs.MINER && this.quest_stage == 2) {
            return this.getLocalized("complete", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (npc == HFNPCs.TOOL_OWNER) {
            if (this.isCompletedEarly || this.quest_stage == 1) {
                if (this.isCompletedEarly) {
                    this.complete(player);
                } else {
                    this.increaseStage(player);
                }
                this.rewardItem(player, HFTools.HAMMER.getStack(ITiered.ToolTier.BASIC));
            }
        } else if (npc == HFNPCs.MINER && this.quest_stage == 2) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, new ItemStack((Item)HFMining.MATERIALS, 10, ItemMaterial.Material.COPPER.ordinal()));
    }
}

