/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.QuestQuestion;
import joshie.harvest.core.HFCore;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.QuestHelper;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.TutorialSelection;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFQuest(value="tutorial.intro")
public class QuestIntro
extends QuestQuestion {
    private static final int HELLO = 0;
    private static final int BACKSTORY = 1;

    public QuestIntro() {
        super(new TutorialSelection("intro"));
        this.setNPCs(HFNPCs.GODDESS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isCompletedEarly) {
            return this.getLocalized("completed", new Object[0]);
        }
        if (this.quest_stage == 0) {
            return this.getLocalized("hello", new Object[0]);
        }
        if (this.quest_stage == 1) {
            return this.getLocalized("backstory", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isCompletedEarly) {
            QuestHelper.INSTANCE.completeQuest(Quests.TUTORIAL_CARPENTER, player);
        }
        if (this.quest_stage == 1 || this.isCompletedEarly) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, new ItemStack((Block)HFCore.FLOWERS, 4, 0));
    }
}

