/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import joshie.harvest.api.npc.INPC;
import joshie.harvest.blocks.HFBlocks;
import joshie.harvest.buildings.loader.HFBuildings;
import joshie.harvest.core.helpers.QuestHelper;
import joshie.harvest.core.helpers.generic.OreDictionaryHelper;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.items.HFItems;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.Quest;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class QuestGoddess
extends Quest {
    @Override
    protected INPC[] getNPCs() {
        return new INPC[]{HFNPCs.GODDESS, HFNPCs.SEED_OWNER};
    }

    @Override
    public void onStageChanged(EntityPlayer player, int previous, int stage) {
        if (previous == 0) {
            QuestHelper.rewardItem(player, new ItemStack((Block)HFBlocks.FLOWERS, 4, 0));
        } else if (previous == 1) {
            QuestHelper.rewardItem(player, HFBuildings.carpenter.getProvider().getPreview());
            QuestHelper.rewardItem(player, new ItemStack((Block)Blocks.field_150328_O, 1, player.field_70170_p.field_73012_v.nextInt(8)));
        } else if (previous == 3) {
            ItemStack seeds = HFCrops.turnip.getSeedStack().func_77946_l();
            seeds.field_77994_a = 10;
            QuestHelper.rewardItem(player, seeds);
        }
    }

    @Override
    public void claim(EntityPlayer player) {
        QuestHelper.rewardGold(player, 1000L);
        QuestHelper.rewardItem(player, new ItemStack(HFItems.HOE));
        QuestHelper.rewardItem(player, new ItemStack(HFItems.WATERING_CAN));
        QuestHelper.rewardItem(player, new ItemStack(HFItems.SICKLE));
    }

    @Override
    public String getScript(EntityPlayer player, INPC npc) {
        if (npc == HFNPCs.GODDESS) {
            if (this.quest_stage == 0) {
                this.increaseStage(player);
                return "welcome";
            }
            if (this.quest_stage == 1) {
                boolean isLogs;
                ItemStack held = player.func_184607_cu();
                if (held != null && (isLogs = OreDictionaryHelper.isLogs(held)) && held.field_77994_a >= 64) {
                    QuestHelper.takeHeldStack(player, 64);
                    this.increaseStage(player);
                    return "thanks";
                }
                return "reminder.welcome";
            }
            if (this.quest_stage == 2 || this.quest_stage == 3) {
                return "reminder.seeds";
            }
            if (this.quest_stage == 4) {
                QuestHelper.completeQuest(player, this);
                return "completed";
            }
        } else if (npc == HFNPCs.SEED_OWNER) {
            if (this.quest_stage == 2) {
                this.increaseStage(player);
                return "jade.hello";
            }
            if (this.quest_stage == 3) {
                boolean isFlowers;
                ItemStack held = player.func_184607_cu();
                if (held != null && (isFlowers = OreDictionaryHelper.isFlowers(held)) && held.field_77994_a >= 3) {
                    QuestHelper.takeHeldStack(player, 3);
                    this.increaseStage(player);
                    return "jade.complete";
                }
                return "jade.reminder";
            }
            if (this.quest_stage == 4) {
                return "jade.goddess";
            }
        }
        return null;
    }
}

