/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import java.util.Set;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.api.quests.QuestQuestion;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.TutorialSelection;
import joshie.harvest.tools.HFTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

@HFQuest(value="tutorial.crops")
public class QuestCrops
extends QuestQuestion {
    private static final int INTRO = 0;
    private static final int START = 1;
    private static final int TURNIPS = 2;
    private boolean attempted;

    public QuestCrops() {
        super(new TutorialSelection("crops"));
        this.setNPCs(HFNPCs.SEED_OWNER);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_CARPENTER);
    }

    @Override
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isCompletedEarly) {
            return this.getLocalized("completed", new Object[0]);
        }
        if (this.quest_stage == 0) {
            return this.getLocalized("intro", new Object[0]);
        }
        if (this.quest_stage == 1) {
            return this.getLocalized("start", new Object[0]);
        }
        if (this.quest_stage == 2) {
            if (this.attempted) {
                if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.FLOWER, 5) != null) {
                    return this.getLocalized("thanks.flowers", new Object[0]);
                }
                if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.HOE, new int[0]) != null) {
                    return this.getLocalized("thanks.hoe", new Object[0]);
                }
                if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.BUCKET, new int[0]) != null) {
                    return this.getLocalized("thanks.bucket", new Object[0]);
                }
            }
            if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM_STACK, HFCrops.TUTORIAL.getCropStack(9), 9) != null) {
                return this.getLocalized("complete", new Object[0]);
            }
            this.attempted = true;
            return this.getLocalized("reminder.turnips", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isCompletedEarly || this.quest_stage == 1) {
            this.rewardItem(player, HFTools.HOE.getStack(ITiered.ToolTier.BASIC));
            this.rewardItem(player, HFTools.WATERING_CAN.getStack(ITiered.ToolTier.BASIC));
            if (this.quest_stage == 1) {
                this.rewardItem(player, HFCrops.TUTORIAL.getSeedStack(3));
            }
            if (this.isCompletedEarly) {
                this.complete(player);
            }
            if (this.quest_stage == 1) {
                this.increaseStage(player);
            }
        } else if (this.quest_stage == 2) {
            if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM_STACK, HFCrops.TUTORIAL.getCropStack(9), 9) != null) {
                this.complete(player);
            }
            if (this.attempted) {
                if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.FLOWER, 5) != null) {
                    this.rewardItem(player, HFCrops.TUTORIAL.getSeedStack(1));
                } else if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.HOE, new int[0]) != null) {
                    this.rewardItem(player, HFTools.HOE.getStack(ITiered.ToolTier.BASIC));
                } else if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.BUCKET, new int[0]) != null) {
                    this.rewardItem(player, HFTools.WATERING_CAN.getStack(ITiered.ToolTier.BASIC));
                }
            }
            this.attempted = true;
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, HFTools.SICKLE.getStack(ITiered.ToolTier.BASIC));
        Season season = HFApi.calendar.getSeasonAtCoordinates(player.field_70170_p, new BlockPos((Entity)player));
        if (season == Season.SUMMER) {
            this.rewardItem(player, HFCrops.ONION.getSeedStack(3));
        } else if (season == Season.AUTUMN) {
            this.rewardItem(player, HFCrops.CARROT.getSeedStack(3));
        } else {
            this.rewardItem(player, HFCrops.TURNIP.getSeedStack(3));
        }
    }
}

