/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import java.util.Set;
import javax.annotation.Nullable;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.block.BlockTrough;
import joshie.harvest.animals.entity.EntityHarvestCow;
import joshie.harvest.animals.item.ItemAnimalTool;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.api.quests.QuestQuestion;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.TutorialSelection;
import joshie.harvest.tools.ToolHelper;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

@HFQuest(value="tutorial.cow")
public class QuestCowCare
extends QuestQuestion {
    private static final int START = 0;
    private static final int INFO = 1;
    private static final int ACTION1 = 2;
    private static final int ACTION2 = 3;
    private static final int MILKER = 4;
    private static final int MILKING = 5;
    private boolean hasFed;
    private boolean hasBrushed;
    private boolean hasMilked;

    public QuestCowCare() {
        super(new TutorialSelection("cow"));
        this.setNPCs(HFNPCs.BUILDER, HFNPCs.ANIMAL_OWNER);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_CROPS);
    }

    @Override
    public void onEntityInteract(EntityPlayer player, @Nullable ItemStack held, EnumHand hand, Entity target) {
        if ((this.quest_stage == 2 || this.quest_stage == 3) && target instanceof EntityHarvestCow && held != null) {
            if (!this.hasFed && held.func_77969_a(HFCrops.GRASS.getCropStack(1))) {
                this.hasFed = true;
                this.increaseStage(player);
            } else if (!this.hasBrushed && ToolHelper.isBrush(held)) {
                this.hasBrushed = true;
                this.increaseStage(player);
            }
        }
    }

    @Override
    public Quest.Selection getSelection(EntityPlayer player, INPC npc) {
        return npc == HFNPCs.ANIMAL_OWNER && this.quest_stage <= 0 ? this.selection : null;
    }

    @Override
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (npc == HFNPCs.BUILDER) {
            if (player.field_70170_p.field_73012_v.nextFloat() < 0.15f) {
                if (((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)entity)).hasBuilding(HFBuildings.BARN)) {
                    return this.getLocalized("reminder.intro", new Object[0]);
                }
                return this.getLocalized("reminder.barn", new Object[0]);
            }
            return null;
        }
        if (npc == HFNPCs.ANIMAL_OWNER) {
            if (this.isCompletedEarly) {
                return this.getLocalized("completed", new Object[0]);
            }
            if (this.quest_stage == 0) {
                return this.getLocalized("start", new Object[0]);
            }
            if (this.quest_stage == 1) {
                return this.getLocalized("info", new Object[0]);
            }
            if (this.quest_stage == 2 || this.quest_stage == 3) {
                return this.getLocalized("reminder.talk", new Object[0]);
            }
            if (this.quest_stage == 4) {
                return this.getLocalized("milk", new Object[0]);
            }
            if (this.quest_stage == 5) {
                if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM_STACK, HFAnimals.MILK.getStack(ISizeable.Size.SMALL), new int[0]) != null) {
                    return this.getLocalized("complete", new Object[0]);
                }
                return this.getLocalized("reminder.milk", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isCompletedEarly || this.quest_stage == 1) {
            if (this.isCompletedEarly) {
                this.complete(player);
                this.rewardItem(player, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.MILKER));
            } else {
                this.increaseStage(player);
            }
            this.rewardEntity(player, "harvestfestival.cow");
            this.rewardItem(player, new ItemStack(Items.field_151058_ca));
            this.rewardItem(player, HFCrops.GRASS.getCropStack(64));
            this.rewardItem(player, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.BRUSH));
        } else if (this.quest_stage == 4) {
            this.increaseStage(player);
            this.rewardItem(player, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.MILKER));
        } else if (this.quest_stage == 5 && InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM_STACK, HFAnimals.MILK.getStack(ISizeable.Size.SMALL), new int[0]) != null) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, HFAnimals.MILK.getStackOfSize(ISizeable.Size.LARGE, 3));
        this.rewardItem(player, HFAnimals.TROUGH.getStackFromEnum(BlockTrough.Trough.WOOD));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.hasFed = nbt.func_74767_n("HasFed");
        this.hasBrushed = nbt.func_74767_n("HasBrushed");
        this.hasMilked = nbt.func_74767_n("HasMilked");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("HasFed", this.hasFed);
        nbt.func_74757_a("HasBrushed", this.hasBrushed);
        nbt.func_74757_a("HasMilked", this.hasMilked);
        return nbt;
    }
}

