/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import java.util.Set;
import javax.annotation.Nullable;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.block.BlockTray;
import joshie.harvest.animals.entity.EntityHarvestChicken;
import joshie.harvest.animals.item.ItemAnimalTool;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.api.quests.QuestQuestion;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.TutorialSelection;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

@HFQuest(value="tutorial.chicken")
public class QuestChickenCare
extends QuestQuestion {
    private static final int INTRO = 0;
    private static final int THROW = 1;
    private static final int ACTION1 = 2;
    private static final int ACTION2 = 3;
    private static final int EGG = 4;
    private static final int FINAL = 5;
    private boolean hasThrown;
    private boolean hasFed;

    public QuestChickenCare() {
        super(new TutorialSelection("chicken"));
        this.setNPCs(HFNPCs.GODDESS, HFNPCs.POULTRY);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_CROPS);
    }

    @Override
    public void onEntityInteract(EntityPlayer player, @Nullable ItemStack held, EnumHand hand, Entity target) {
        if (!this.hasFed && (this.quest_stage == 2 || this.quest_stage == 3) && target instanceof EntityChicken && held != null) {
            if (InventoryHelper.ITEM_STACK.matches(held, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.CHICKEN_FEED))) {
                this.hasFed = true;
            }
            this.increaseStage(player);
        }
    }

    @Override
    public void onRightClickBlock(EntityPlayer player, BlockPos pos, EnumFacing face) {
        if (!(this.hasThrown || this.quest_stage != 2 && this.quest_stage != 3)) {
            for (Entity entity : player.func_184188_bt()) {
                if (!(entity instanceof EntityHarvestChicken)) continue;
                this.hasThrown = true;
                this.increaseStage(player);
            }
        }
    }

    @Override
    public Quest.Selection getSelection(EntityPlayer player, INPC npc) {
        return npc == HFNPCs.POULTRY && this.quest_stage <= 0 ? this.selection : null;
    }

    @Override
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (npc == HFNPCs.GODDESS) {
            if (player.field_70170_p.field_73012_v.nextFloat() < 0.15f) {
                if (((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)entity)).hasBuilding(HFBuildings.POULTRY_FARM)) {
                    return this.getLocalized("reminder.talk", new Object[0]);
                }
                return this.getLocalized("reminder.poultry", new Object[0]);
            }
            return null;
        }
        if (npc == HFNPCs.POULTRY) {
            if (this.isCompletedEarly) {
                return this.getLocalized("completed", new Object[0]);
            }
            if (this.quest_stage == 0) {
                return this.getLocalized("start", new Object[0]);
            }
            if (this.quest_stage == 1) {
                return this.getLocalized("throw", new Object[0]);
            }
            if (this.quest_stage == 2 || this.quest_stage == 3) {
                return this.getLocalized("reminder.throw", new Object[0]);
            }
            if (this.quest_stage == 4) {
                return this.getLocalized("egg", new Object[0]);
            }
            if (this.quest_stage == 5) {
                if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM_STACK, HFAnimals.EGG.getStack(ISizeable.Size.SMALL), new int[0]) != null) {
                    return this.getLocalized("complete", new Object[0]);
                }
                return this.getLocalized("reminder.egg", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isCompletedEarly) {
            this.complete(player);
            this.rewardEntity(player, "harvestfestival.chicken");
            this.rewardItem(player, new ItemStack((Item)HFAnimals.TOOLS, 64, ItemAnimalTool.Tool.CHICKEN_FEED.ordinal()));
            this.rewardItem(player, HFAnimals.TRAY.getStackFromEnum(BlockTray.Tray.NEST_EMPTY));
            this.rewardItem(player, HFAnimals.EGG.getStack(ISizeable.Size.LARGE));
        } else if (this.quest_stage == 1) {
            this.increaseStage(player);
            this.rewardEntity(player, "harvestfestival.chicken");
            this.rewardItem(player, new ItemStack((Item)HFAnimals.TOOLS, 16, ItemAnimalTool.Tool.CHICKEN_FEED.ordinal()));
        } else if (this.quest_stage == 4) {
            this.increaseStage(player);
            this.rewardItem(player, HFAnimals.TRAY.getStackFromEnum(BlockTray.Tray.NEST_EMPTY));
        } else if (this.quest_stage == 5 && InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM_STACK, HFAnimals.EGG.getStack(ISizeable.Size.SMALL), new int[0]) != null) {
            this.complete(player);
            this.rewardItem(player, HFAnimals.EGG.getStack(ISizeable.Size.LARGE));
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, HFAnimals.EGG.getStackOfSize(ISizeable.Size.LARGE, 3));
        this.rewardItem(player, HFAnimals.TRAY.getStackFromEnum(BlockTray.Tray.FEEDER_EMPTY));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.hasThrown = nbt.func_74767_n("HasThrown");
        this.hasFed = nbt.func_74767_n("HasFed");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("HasThrown", this.hasThrown);
        nbt.func_74757_a("HasFed", this.hasFed);
        return nbt;
    }
}

