/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import java.util.Set;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.HFQuests;
import joshie.harvest.quests.Quests;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;

@HFQuest(value="tutorial.carpenter")
public class QuestCarpenter
extends Quest {
    private static final int WELCOME = 0;
    private static final int LOGS = 1;
    private static final int SEED_CHAT = 2;
    private static final int FINISHED = 3;
    private boolean attempted = false;

    public QuestCarpenter() {
        this.setNPCs(HFNPCs.GODDESS, HFNPCs.BUILDER, HFNPCs.SEED_OWNER);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_INTRO);
    }

    private String getWoodAmount() {
        if (HFQuests.LOGS_CARPENTER == 24) {
            return this.getLocalized("wood.dozentwo", new Object[0]);
        }
        if (HFQuests.LOGS_CARPENTER == 12) {
            return this.getLocalized("wood.dozen", new Object[0]);
        }
        if (HFQuests.LOGS_CARPENTER == 64) {
            return this.getLocalized("wood.stack", new Object[0]);
        }
        if (HFQuests.LOGS_CARPENTER == 32) {
            return this.getLocalized("wood.stackhalf", new Object[0]);
        }
        if (HFQuests.LOGS_CARPENTER == 16) {
            return this.getLocalized("wood.stackquarter", new Object[0]);
        }
        return "" + HFQuests.LOGS_CARPENTER;
    }

    @Override
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.quest_stage == 0 && npc == HFNPCs.GODDESS) {
            return this.getLocalized("welcome", this.getWoodAmount());
        }
        if (this.quest_stage == 1 && npc == HFNPCs.GODDESS) {
            if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.ORE_DICTIONARY, "logWood", HFQuests.LOGS_CARPENTER) != null) {
                return this.getLocalized("thanks.build", new Object[0]);
            }
            return this.getLocalized("reminder.wood", this.getWoodAmount());
        }
        if (this.quest_stage == 2) {
            if (npc == HFNPCs.GODDESS) {
                if (this.attempted && InventoryHelper.getHandItemIsIn(player, InventoryHelper.ORE_DICTIONARY, "logWood", HFQuests.LOGS_CARPENTER) != null) {
                    return this.getLocalized("reminder.give", new Object[0]);
                }
                this.attempted = true;
                return this.getLocalized("reminder.carpenter", this.getWoodAmount());
            }
            if (npc == HFNPCs.SEED_OWNER) {
                if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.FLOWER, 1) != null) {
                    return this.getLocalized("thanks.flowers", new Object[0]);
                }
                return this.getLocalized("reminder.flowers", new Object[0]);
            }
        } else if (this.quest_stage == 3 && npc == HFNPCs.GODDESS) {
            return this.getLocalized("thanks.finish", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.quest_stage == 0 && npc == HFNPCs.GODDESS) {
            this.increaseStage(player);
        } else if (this.quest_stage == 1 && npc == HFNPCs.GODDESS) {
            if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.ORE_DICTIONARY, "logWood", HFQuests.LOGS_CARPENTER) != null) {
                if (HFBuildings.CHEAT_BUILDINGS) {
                    this.rewardItem(player, HFBuildings.CARPENTER.getSpawner());
                } else {
                    this.rewardItem(player, HFBuildings.CARPENTER.getBlueprint());
                }
                this.increaseStage(player);
            }
        } else if (this.quest_stage == 2) {
            if (npc == HFNPCs.GODDESS) {
                if (this.attempted && InventoryHelper.takeItemsIfHeld(player, InventoryHelper.ORE_DICTIONARY, "logWood", HFQuests.LOGS_CARPENTER) != null) {
                    this.rewardItem(player, HFBuildings.CARPENTER.getBlueprint());
                } else {
                    this.attempted = true;
                }
            } else if (npc == HFNPCs.SEED_OWNER && InventoryHelper.takeItemsIfHeld(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.FLOWER, 1) != null) {
                this.increaseStage(player);
            }
        } else if (this.quest_stage == 3 && npc == HFNPCs.GODDESS) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardGold(player, 1000L);
    }
}

