/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.tutorial;

import java.util.Set;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.api.quests.QuestQuestion;
import joshie.harvest.cooking.CookingHelper;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.cooking.block.BlockCookware;
import joshie.harvest.cooking.item.ItemUtensil;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.TutorialSelection;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@HFQuest(value="tutorial.cafe")
public class QuestCafe
extends QuestQuestion {
    private static final int WELCOME = 0;
    private static final int TUTORIAL = 1;

    public QuestCafe() {
        super(new TutorialSelection("cafe"));
        this.setNPCs(HFNPCs.CAFE_OWNER);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_UPGRADING);
    }

    @Override
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isCompletedEarly) {
            return this.getLocalized("completed", new Object[0]);
        }
        if (this.quest_stage == 0) {
            return this.getLocalized("welcome", new Object[0]);
        }
        if (this.quest_stage == 1) {
            return this.getLocalized("explain", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isCompletedEarly || this.quest_stage == 1) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, HFCooking.UTENSILS.getStackFromEnum(ItemUtensil.Utensil.KNIFE));
        this.rewardItem(player, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.COUNTER));
        this.rewardItem(player, new ItemStack((Item)HFCooking.COOKBOOK));
        this.rewardItem(player, CookingHelper.getRecipe("turnip_pickled"));
    }
}

