/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.trade;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.core.base.item.ItemTool;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.core.helpers.SpawnItemHelper;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.item.ItemMaterial;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.quests.trade.QuestTrade;
import joshie.harvest.tools.HFTools;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFQuest(value="trade.upgrade")
public class QuestUpgrade
extends QuestTrade {
    private static final int TEST = 0;
    private CalendarDate date;
    private ItemStack tool;
    private int days;

    public QuestUpgrade() {
        this.setNPCs(HFNPCs.TOOL_OWNER);
    }

    private int getDifference(CalendarDate then, CalendarDate now) {
        int thenDays = CalendarHelper.getTotalDays(then);
        int nowDays = CalendarHelper.getTotalDays(now);
        return nowDays - thenDays;
    }

    private long getCost(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: {
                return 1000L;
            }
            case COPPER: {
                return 2000L;
            }
            case SILVER: {
                return 5000L;
            }
            case GOLD: {
                return 10000L;
            }
            case BLESSED: {
                return 100000L;
            }
            case MYTHIC: {
                return 200000L;
            }
        }
        return 0L;
    }

    private int getRequired(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: 
            case COPPER: 
            case SILVER: {
                return 10;
            }
            case GOLD: {
                return 5;
            }
            case BLESSED: {
                return 1;
            }
        }
        return 0;
    }

    private int getMaterial(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: {
                return ItemMaterial.Material.COPPER.ordinal();
            }
            case COPPER: {
                return ItemMaterial.Material.SILVER.ordinal();
            }
            case SILVER: {
                return ItemMaterial.Material.GOLD.ordinal();
            }
            case GOLD: {
                return ItemMaterial.Material.MYSTRIL.ordinal();
            }
            case BLESSED: {
                return ItemMaterial.Material.MYTHIC.ordinal();
            }
        }
        return 0;
    }

    private ItemStack getUpgradeMaterial(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: {
                return new ItemStack(Blocks.field_150348_b);
            }
            case COPPER: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.COPPER);
            }
            case SILVER: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.SILVER);
            }
            case GOLD: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.GOLD);
            }
            case MYSTRIL: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.MYSTRIL);
            }
            case MYTHIC: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.MYTHIC);
            }
        }
        return null;
    }

    private double getLevel(EntityPlayer player) {
        ItemStack held = player.func_184614_ca();
        if (held == null) {
            return 0.0;
        }
        if (held.func_77973_b() instanceof ITiered) {
            return ((ITiered)held.func_77973_b()).getLevel(held);
        }
        return 0.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.quest_stage == 0) {
            ITiered.ToolTier broken = this.isHoldingBrokenTool(player);
            if (broken != null) {
                long required = this.getCost(broken) / 10L;
                if (((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getGold() < required) {
                    return this.getLocalized("repair.gold", required);
                }
                ItemStack material = this.getUpgradeMaterial(broken);
                if (InventoryHelper.hasInInventory(player, InventoryHelper.ITEM_STACK, material, new int[0])) {
                    return this.getLocalized("repair.start", new Object[0]);
                }
                return this.getLocalized("repair.material", material.func_82833_r());
            }
            ITiered.ToolTier holding = this.isHolding(player);
            if (holding != null) {
                boolean hasGold;
                if (this.getLevel(player) != 100.0) {
                    return this.getLocalized("level", new Object[0]);
                }
                long required = this.getCost(holding);
                boolean bl = hasGold = ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getGold() >= required;
                if (!hasGold) {
                    return this.getLocalized("gold", required);
                }
                ItemStack material = new ItemStack((Item)HFMining.MATERIALS, this.getRequired(holding), this.getMaterial(holding));
                boolean hasMaterial = InventoryHelper.hasInInventory(player, InventoryHelper.ITEM_STACK, material, this.getRequired(holding));
                if (!hasMaterial) {
                    return this.getLocalized("material", material.field_77994_a, material.func_82833_r());
                }
                return this.getLocalized("accept", new Object[0]);
            }
            return null;
        }
        CalendarDate today = HFApi.calendar.getDate(player.field_70170_p);
        if (this.getDifference(this.date, today) >= this.days) {
            return this.getLocalized("done", this.tool.func_82833_r());
        }
        return this.getLocalized("wait", this.days - this.getDifference(this.date, today));
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        block8: {
            block7: {
                if (this.quest_stage != 0) break block7;
                ITiered.ToolTier broken = this.isHoldingBrokenTool(player);
                if (broken != null) {
                    long required = this.getCost(broken) / 10L;
                    if (((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getGold() < required) {
                        return;
                    }
                    ItemStack material = this.getUpgradeMaterial(broken);
                    if (InventoryHelper.takeItemsInInventory(player, InventoryHelper.ITEM_STACK, material, new int[0])) {
                        this.date = HFApi.calendar.getDate(player.field_70170_p).copy();
                        this.tool = player.func_184614_ca().func_77946_l();
                        this.tool.func_179543_a("Data", true).func_74768_a("Damage", 0);
                        this.tool.func_179543_a("Data", true).func_74780_a("Level", this.tool.func_179543_a("Data", true).func_74769_h("Level"));
                        this.days = 1;
                        this.increaseStage(player);
                        this.rewardGold(player, -required);
                        this.takeHeldStack(player, 1);
                    }
                    return;
                }
                ITiered.ToolTier holding = this.isHolding(player);
                if (holding == null) break block8;
                if (this.getLevel(player) != 100.0) {
                    return;
                }
                long required = this.getCost(holding);
                if (((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getGold() < required) {
                    return;
                }
                if (!InventoryHelper.takeItemsInInventory(player, InventoryHelper.ITEM_STACK, new ItemStack((Item)HFMining.MATERIALS, 1, this.getMaterial(holding)), this.getRequired(holding))) break block8;
                this.date = HFApi.calendar.getDate(player.field_70170_p).copy();
                this.tool = player.func_184614_ca().func_77946_l();
                this.tool.func_77982_d(null);
                this.tool.func_77964_b(this.tool.func_77952_i() + 1);
                this.days = 3;
                this.increaseStage(player);
                this.rewardGold(player, -required);
                this.takeHeldStack(player, 1);
                break block8;
            }
            CalendarDate today = HFApi.calendar.getDate(player.field_70170_p);
            if (this.getDifference(this.date, today) >= this.days) {
                this.complete(player);
                player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187686_e, SoundCategory.NEUTRAL, 0.25f, 1.0f);
                for (int i = 0; i < 32; ++i) {
                    player.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, entity.field_70165_t + (double)player.field_70170_p.field_73012_v.nextFloat() + (double)player.field_70170_p.field_73012_v.nextFloat() - 1.0, entity.field_70163_u + 0.25 + (double)entity.field_70170_p.field_73012_v.nextFloat() + (double)entity.field_70170_p.field_73012_v.nextFloat(), entity.field_70161_v + (double)player.field_70170_p.field_73012_v.nextFloat() + (double)player.field_70170_p.field_73012_v.nextFloat() - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, this.tool);
        SpawnItemHelper.spawnXP(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 5);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("Date")) {
            this.date = CalendarDate.fromNBT(nbt.func_74775_l("Date"));
            this.tool = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Item"));
            this.days = nbt.func_74771_c("Days");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.date != null) {
            nbt.func_74782_a("Date", (NBTBase)this.date.toNBT());
            nbt.func_74782_a("Item", (NBTBase)this.tool.func_77955_b(new NBTTagCompound()));
            nbt.func_74774_a("Days", (byte)this.days);
        }
        return nbt;
    }

    private boolean isRepairable(ItemStack stack, ITiered.ToolTier tier) {
        if (tier == ITiered.ToolTier.CURSED || tier == ITiered.ToolTier.BLESSED) {
            return false;
        }
        return HFTools.HAMMER.getDamageForDisplay(stack) != 0;
    }

    private ITiered.ToolTier isHoldingBrokenTool(EntityPlayer player) {
        ItemStack held = player.func_184614_ca();
        if (held != null && held.func_77973_b() instanceof ItemTool) {
            ItemTool tool = (ItemTool)held.func_77973_b();
            ITiered.ToolTier tier = tool.getTier(held);
            if (tool == HFTools.WATERING_CAN) {
                return null;
            }
            return this.isRepairable(held, tier) ? tier : null;
        }
        return null;
    }

    private ITiered.ToolTier isHolding(EntityPlayer player) {
        ItemStack held = player.func_184614_ca();
        if (held != null && held.func_77973_b() instanceof ItemTool) {
            ItemTool tool = (ItemTool)held.func_77973_b();
            ITiered.ToolTier tier = tool.getTier(held);
            return this.getRequired(tier) > 0 ? tier : null;
        }
        return null;
    }
}

