/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.trade;

import joshie.harvest.animals.HFAnimals;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.lib.Sizeable;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.trade.QuestTrade;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFQuest(value="trade.vanilla")
public class QuestTrader
extends QuestTrade {
    private static final Item WOOL = Item.func_150898_a((Block)Blocks.field_150325_L);

    public QuestTrader() {
        this.setNPCs(HFNPCs.TRADER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isHoldingInEitherHand(player, HFAnimals.EGG)) {
            return this.getLocalized("egg", new Object[0]);
        }
        if (this.isHoldingInEitherHand(player, HFAnimals.MILK)) {
            return this.getLocalized("milk", new Object[0]);
        }
        if (this.isHoldingInEitherHand(player, HFAnimals.WOOL)) {
            return this.getLocalized("wool", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.isHoldingAnyAtAll(player)) {
            EnumHand hand;
            EnumHand enumHand = hand = this.isHoldingAny(player, EnumHand.MAIN_HAND) ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            if (player.func_184586_b(hand) != null) {
                ItemStack held = player.func_184586_b(hand).func_77946_l();
                this.takeHeldStack(player, held.field_77994_a);
                ISizeable.Size size = HFApi.sizeable.getSize(held);
                int amount = held.field_77994_a;
                if (size == ISizeable.Size.MEDIUM) {
                    amount *= 2;
                } else if (size == ISizeable.Size.LARGE) {
                    amount *= 3;
                }
                Sizeable sizeable = HFCore.SIZEABLE.getObjectFromStack(held);
                Item item = sizeable == HFAnimals.EGG ? Items.field_151110_aK : (sizeable == HFAnimals.MILK ? Items.field_151117_aB : WOOL);
                this.rewardItem(player, new ItemStack(item, amount));
            }
        }
    }

    private boolean isHoldingAnyAtAll(EntityPlayer player) {
        return this.isHoldingAny(player, EnumHand.MAIN_HAND) || this.isHoldingAny(player, EnumHand.OFF_HAND);
    }

    private boolean isHoldingAny(EntityPlayer player, EnumHand hand) {
        return this.isHolding(player, HFAnimals.EGG, hand) || this.isHolding(player, HFAnimals.MILK, hand) || this.isHolding(player, HFAnimals.WOOL, hand);
    }

    private boolean isHolding(EntityPlayer player, Sizeable sizeable, EnumHand hand) {
        return player.func_184586_b(hand) != null && sizeable.matches(player.func_184586_b(hand));
    }

    private boolean isHoldingInEitherHand(EntityPlayer player, Sizeable sizeable) {
        return this.isHolding(player, sizeable, EnumHand.MAIN_HAND) || this.isHolding(player, sizeable, EnumHand.OFF_HAND);
    }
}

