/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.trade;

import java.util.Set;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.trade.QuestTrade;
import joshie.harvest.tools.HFTools;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFQuest(value="trade.tools")
public class QuestToolTrader
extends QuestTrade {
    public QuestToolTrader() {
        this.setNPCs(HFNPCs.SEED_OWNER);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_CROPS) && !finished.contains((Object)Quests.TUTORIAL_UPGRADING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.HOE, new int[0]) != null) {
            return this.getLocalized("hoe", new Object[0]);
        }
        if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.BUCKET, new int[0]) != null) {
            return this.getLocalized("wateringcan", new Object[0]);
        }
        if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.SHEARS, new int[0]) != null) {
            return this.getLocalized("sickle", new Object[0]);
        }
        if (player.field_70170_p.field_73012_v.nextFloat() <= 0.05f) {
            return this.getLocalized("reminder", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.HOE, new int[0]) != null || InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.BUCKET, new int[0]) != null || InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.SHEARS, new int[0]) != null) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.HOE, new int[0]) != null) {
            this.rewardItem(player, HFTools.HOE.getStack(ITiered.ToolTier.BASIC));
        } else if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.BUCKET, new int[0]) != null) {
            this.rewardItem(player, HFTools.WATERING_CAN.getStack(ITiered.ToolTier.BASIC));
        } else if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.SHEARS, new int[0]) != null) {
            this.rewardItem(player, HFTools.SICKLE.getStack(ITiered.ToolTier.BASIC));
        }
    }
}

