/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.trade;

import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.SpawnItemHelper;
import joshie.harvest.core.lib.HFSounds;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.quests.trade.QuestTrade;
import joshie.harvest.tools.HFTools;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFQuest(value="trade.bless")
public class QuestPriestRepair
extends QuestTrade {
    private static final ItemStack hoe = HFTools.HOE.getStack(ITiered.ToolTier.BLESSED);
    private static final ItemStack sickle = HFTools.SICKLE.getStack(ITiered.ToolTier.BLESSED);
    private static final ItemStack watering = HFTools.WATERING_CAN.getStack(ITiered.ToolTier.BLESSED);
    private static final ItemStack axe = HFTools.AXE.getStack(ITiered.ToolTier.BLESSED);
    private static final ItemStack hammer = HFTools.HAMMER.getStack(ITiered.ToolTier.BLESSED);

    public QuestPriestRepair() {
        this.setNPCs(HFNPCs.PRIEST);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        boolean hasTool;
        boolean hasGold = ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getGold() >= 500L;
        boolean bl = hasTool = this.isHolding(player, hoe) || this.isHolding(player, sickle) || this.isHolding(player, watering) || this.isHolding(player, axe) || this.isHolding(player, hammer);
        if (hasGold && hasTool) {
            ItemStack tool = player.func_184614_ca();
            return this.getLocalized("done", tool.func_82833_r());
        }
        if (hasTool) {
            return this.getLocalized("gold", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        boolean hasTool;
        boolean hasGold = ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getGold() >= 500L;
        boolean bl = hasTool = this.isHolding(player, hoe) || this.isHolding(player, sickle) || this.isHolding(player, watering) || this.isHolding(player, axe) || this.isHolding(player, hammer);
        if (hasGold && hasTool) {
            this.complete(player);
            player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, HFSounds.BLESS_TOOL, SoundCategory.NEUTRAL, 0.25f, 1.0f);
            for (int i = 0; i < 32; ++i) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entity.field_70165_t + (double)player.field_70170_p.field_73012_v.nextFloat() + (double)player.field_70170_p.field_73012_v.nextFloat() - 1.0, entity.field_70163_u + 0.25 + (double)entity.field_70170_p.field_73012_v.nextFloat() + (double)entity.field_70170_p.field_73012_v.nextFloat(), entity.field_70161_v + (double)player.field_70170_p.field_73012_v.nextFloat() + (double)player.field_70170_p.field_73012_v.nextFloat() - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        if (player.func_184614_ca() != null) {
            ItemStack stack = player.func_184614_ca().func_77946_l();
            ItemStack tool = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
            tool.func_179543_a("Data", true).func_74780_a("Level", stack.func_179543_a("Data", true).func_74769_h("Level"));
            this.rewardGold(player, -500L);
            this.takeHeldStack(player, 1);
            this.rewardItem(player, tool);
            SpawnItemHelper.spawnXP(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 5);
        }
    }

    private boolean isHolding(EntityPlayer player, ItemStack stack) {
        return player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == stack.func_77973_b() && player.func_184614_ca().func_77952_i() == stack.func_77952_i();
    }
}

