/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.trade;

import java.util.Set;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.quests.HFQuests;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.trade.QuestTrade;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFQuest(value="trade.carpenter")
public class QuestGoddessCarpenter
extends QuestTrade {
    public QuestGoddessCarpenter() {
        this.setNPCs(HFNPCs.GODDESS);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_CARPENTER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        return InventoryHelper.getHandItemIsIn(player, InventoryHelper.ORE_DICTIONARY, "logWood", HFQuests.LOGS_CARPENTER) != null ? this.getLocalized("thanks", new Object[0]) : null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.ORE_DICTIONARY, "logWood", HFQuests.LOGS_CARPENTER) != null) {
            if (HFBuildings.CHEAT_BUILDINGS) {
                this.rewardItem(player, HFBuildings.CARPENTER.getSpawner());
            } else {
                this.rewardItem(player, HFBuildings.CARPENTER.getBlueprint());
            }
        }
    }
}

