/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.trade;

import java.util.Set;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.quests.Quests;
import joshie.harvest.quests.trade.QuestTrade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFQuest(value="trade.seeds")
public class QuestFlowerTrader
extends QuestTrade {
    public QuestFlowerTrader() {
        this.setNPCs(HFNPCs.SEED_OWNER);
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_CROPS) && !finished.contains((Object)Quests.TUTORIAL_SUPERMARKET);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (InventoryHelper.getHandItemIsIn(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.FLOWER, 5) != null) {
            Season season = HFApi.calendar.getSeasonAtCoordinates(player.field_70170_p, new BlockPos((Entity)player));
            if (season == Season.SPRING || season == Season.SUMMER || season == Season.AUTUMN) {
                return this.getLocalized("complete.yes", new Object[0]);
            }
            return this.getLocalized("complete.no", new Object[0]);
        }
        if (player.field_70170_p.field_73012_v.nextFloat() <= 0.05f) {
            return this.getLocalized("reminder", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc, boolean wasSneaking) {
        for (int j = 0; j < (player.func_70093_af() ? 10 : 1); ++j) {
            Season season;
            if (InventoryHelper.takeItemsIfHeld(player, InventoryHelper.SPECIAL, InventoryHelper.SearchType.FLOWER, 5) == null || (season = HFApi.calendar.getSeasonAtCoordinates(player.field_70170_p, new BlockPos((Entity)player))) != Season.SPRING && season != Season.SUMMER && season != Season.AUTUMN) continue;
            if (season == Season.SPRING) {
                this.rewardItem(player, HFCrops.TURNIP.getSeedStack(1));
                continue;
            }
            if (season == Season.SUMMER) {
                this.rewardItem(player, HFCrops.ONION.getSeedStack(1));
                continue;
            }
            this.rewardItem(player, HFCrops.CARROT.getSeedStack(1));
        }
        if (!player.field_70170_p.field_72995_K && ((PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer(player)).getQuests().hasCompleted(Quests.TUTORIAL_SUPERMARKET)) {
            this.complete(player);
        }
    }
}

