/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.trade;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.SpawnItemHelper;
import joshie.harvest.core.lib.HFSounds;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.quests.trade.QuestTrade;
import joshie.harvest.tools.HFTools;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFQuest(value="trade.cursed")
public class QuestBless
extends QuestTrade {
    private static final int TEST = 0;
    private static final ItemStack hoe = HFTools.HOE.getStack(ITiered.ToolTier.CURSED);
    private static final ItemStack sickle = HFTools.SICKLE.getStack(ITiered.ToolTier.CURSED);
    private static final ItemStack watering = HFTools.WATERING_CAN.getStack(ITiered.ToolTier.CURSED);
    private static final ItemStack axe = HFTools.AXE.getStack(ITiered.ToolTier.CURSED);
    private static final ItemStack hammer = HFTools.HAMMER.getStack(ITiered.ToolTier.CURSED);
    private CalendarDate today;
    private CalendarDate date;
    private ItemStack tool;

    public QuestBless() {
        this.setNPCs(HFNPCs.PRIEST);
    }

    private int getDifference(CalendarDate then, CalendarDate now) {
        int thenDays = CalendarHelper.getTotalDays(then);
        int nowDays = CalendarHelper.getTotalDays(now);
        return nowDays - thenDays;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.quest_stage == 0) {
            boolean hasTool;
            boolean hasGold = ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getGold() >= 10000L;
            boolean bl = hasTool = this.isHolding(player, hoe) || this.isHolding(player, sickle) || this.isHolding(player, watering) || this.isHolding(player, axe) || this.isHolding(player, hammer);
            if (hasGold && hasTool) {
                return this.getLocalized("accept", new Object[0]);
            }
            if (hasTool) {
                return this.getLocalized("gold", new Object[0]);
            }
            return null;
        }
        CalendarDate today = HFApi.calendar.getDate(player.field_70170_p);
        if (this.getDifference(this.date, today) >= 3) {
            return this.getLocalized("done", this.tool.func_82833_r());
        }
        return this.getLocalized("wait", 3 - this.getDifference(this.date, today));
    }

    @Override
    public void onChatOpened(EntityPlayer player, EntityLiving entity, INPC npc) {
        this.today = HFApi.calendar.getDate(player.field_70170_p);
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (this.quest_stage == 0) {
            boolean hasTool;
            boolean hasGold = ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getGold() >= 10000L;
            boolean bl = hasTool = this.isHolding(player, hoe) || this.isHolding(player, sickle) || this.isHolding(player, watering) || this.isHolding(player, axe) || this.isHolding(player, hammer);
            if (hasGold && hasTool) {
                this.increaseStage(player);
                this.date = HFApi.calendar.getDate(player.field_70170_p).copy();
                ItemStack stack = player.func_184614_ca().func_77946_l();
                this.tool = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i() + 1);
                this.tool.func_77982_d(stack.func_77978_p().func_74737_b());
                this.rewardGold(player, -10000L);
                this.takeHeldStack(player, 1);
            }
        } else if (this.getDifference(this.date, this.today) >= 3) {
            this.complete(player);
            player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, HFSounds.BLESS_TOOL, SoundCategory.NEUTRAL, 0.25f, 1.0f);
            for (int i = 0; i < 32; ++i) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entity.field_70165_t + (double)player.field_70170_p.field_73012_v.nextFloat() + (double)player.field_70170_p.field_73012_v.nextFloat() - 1.0, entity.field_70163_u + 0.25 + (double)entity.field_70170_p.field_73012_v.nextFloat() + (double)entity.field_70170_p.field_73012_v.nextFloat(), entity.field_70161_v + (double)player.field_70170_p.field_73012_v.nextFloat() + (double)player.field_70170_p.field_73012_v.nextFloat() - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, this.tool);
        SpawnItemHelper.spawnXP(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 5);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("Date")) {
            this.date = CalendarDate.fromNBT(nbt.func_74775_l("Date"));
            this.tool = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Item"));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.date != null) {
            nbt.func_74782_a("Date", (NBTBase)this.date.toNBT());
            nbt.func_74782_a("Item", (NBTBase)this.tool.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    private boolean isHolding(EntityPlayer player, ItemStack stack) {
        return player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == stack.func_77973_b() && player.func_184614_ca().func_77952_i() == stack.func_77952_i();
    }
}

