/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.recipes;

import java.util.Set;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.cooking.CookingHelper;
import joshie.harvest.quests.Quests;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestRecipe
extends Quest {
    private final String recipe;
    private final int relationship;

    public QuestRecipe(String recipe, INPC npc, int relationship) {
        this.setNPCs(npc);
        this.recipe = recipe;
        this.relationship = relationship;
    }

    @Override
    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return finished.contains((Object)Quests.TUTORIAL_CAFE);
    }

    @Override
    public boolean isRealQuest() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (HFApi.relationships.getRelationship(player, npc.getUUID()) >= this.relationship) {
            return this.getLocalized("text", new Object[0]);
        }
        return null;
    }

    @Override
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
        if (HFApi.relationships.getRelationship(player, npc.getUUID()) >= this.relationship) {
            this.complete(player);
        }
    }

    @Override
    public void onQuestCompleted(EntityPlayer player) {
        this.rewardItem(player, CookingHelper.getRecipe(this.recipe));
    }
}

