/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.quests.packet;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PenguinPacket;
import joshie.harvest.quests.QuestHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Packet(value=Packet.Side.CLIENT)
public class PacketQuestSetCurrent
extends PenguinPacket {
    private Quest quest;

    public PacketQuestSetCurrent() {
    }

    public PacketQuestSetCurrent(Quest quest) {
        this.quest = quest;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.quest == null);
        if (this.quest != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.quest.getRegistryName().toString());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.quest.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        boolean isNull = buf.readBoolean();
        if (!isNull) {
            Quest q = (Quest)Quest.REGISTRY.getValue(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
            try {
                this.quest = (Quest)((Quest)((Object)((Object)((Object)q)).getClass().newInstance())).setRegistryName(q.getRegistryName());
                this.quest.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        QuestHelper.markAsCurrent(player, this.quest);
    }
}

